/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamNode {
    private final int id;
    private int parallelism;
    private int maxParallelism;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    private final Map<ManagedMemoryUseCase, Integer> managedMemoryOperatorScopeUseCaseWeights = new HashMap<ManagedMemoryUseCase, Integer>();
    private final Set<ManagedMemoryUseCase> managedMemorySlotScopeUseCases = new HashSet<ManagedMemoryUseCase>();
    private long bufferTimeout;
    private final String operatorName;
    @Nullable
    private String slotSharingGroup;
    @Nullable
    private String coLocationGroup;
    private KeySelector<?, ?>[] statePartitioners = new KeySelector[0];
    private TypeSerializer<?> stateKeySerializer;
    private StreamOperatorFactory<?> operatorFactory;
    private TypeSerializer<?>[] typeSerializersIn = new TypeSerializer[0];
    private TypeSerializer<?> typeSerializerOut;
    private List<StreamEdge> inEdges = new ArrayList<StreamEdge>();
    private List<StreamEdge> outEdges = new ArrayList<StreamEdge>();
    private final Class<? extends TaskInvokable> jobVertexClass;
    private InputFormat<?, ?> inputFormat;
    private OutputFormat<?> outputFormat;
    private String transformationUID;
    private String userHash;
    private final Map<Integer, StreamConfig.InputRequirement> inputRequirements = new HashMap<Integer, StreamConfig.InputRequirement>();

    @VisibleForTesting
    public StreamNode(Integer id, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, StreamOperator<?> operator, String operatorName, Class<? extends TaskInvokable> jobVertexClass) {
        this(id, slotSharingGroup, coLocationGroup, SimpleOperatorFactory.of(operator), operatorName, jobVertexClass);
    }

    public StreamNode(Integer id, @Nullable String slotSharingGroup, @Nullable String coLocationGroup, StreamOperatorFactory<?> operatorFactory, String operatorName, Class<? extends TaskInvokable> jobVertexClass) {
        this.id = id;
        this.operatorName = operatorName;
        this.operatorFactory = operatorFactory;
        this.jobVertexClass = jobVertexClass;
        this.slotSharingGroup = slotSharingGroup;
        this.coLocationGroup = coLocationGroup;
    }

    public void addInEdge(StreamEdge inEdge) {
        Preconditions.checkState((boolean)this.outEdges.stream().noneMatch(inEdge::equals), (String)"Adding not unique edge = %s to existing outEdges = %s", (Object[])new Object[]{inEdge, this.inEdges});
        if (inEdge.getTargetId() != this.getId()) {
            throw new IllegalArgumentException("Destination id doesn't match the StreamNode id");
        }
        this.inEdges.add(inEdge);
    }

    public void addOutEdge(StreamEdge outEdge) {
        Preconditions.checkState((boolean)this.outEdges.stream().noneMatch(outEdge::equals), (String)"Adding not unique edge = %s to existing outEdges = %s", (Object[])new Object[]{outEdge, this.outEdges});
        if (outEdge.getSourceId() != this.getId()) {
            throw new IllegalArgumentException("Source id doesn't match the StreamNode id");
        }
        this.outEdges.add(outEdge);
    }

    public List<StreamEdge> getOutEdges() {
        return this.outEdges;
    }

    public List<StreamEdge> getInEdges() {
        return this.inEdges;
    }

    public List<Integer> getOutEdgeIndices() {
        ArrayList<Integer> outEdgeIndices = new ArrayList<Integer>();
        for (StreamEdge edge : this.outEdges) {
            outEdgeIndices.add(edge.getTargetId());
        }
        return outEdgeIndices;
    }

    public List<Integer> getInEdgeIndices() {
        ArrayList<Integer> inEdgeIndices = new ArrayList<Integer>();
        for (StreamEdge edge : this.inEdges) {
            inEdgeIndices.add(edge.getSourceId());
        }
        return inEdgeIndices;
    }

    public int getId() {
        return this.id;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    int getMaxParallelism() {
        return this.maxParallelism;
    }

    void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    public void setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        this.minResources = minResources;
        this.preferredResources = preferredResources;
    }

    public void setManagedMemoryUseCaseWeights(Map<ManagedMemoryUseCase, Integer> operatorScopeUseCaseWeights, Set<ManagedMemoryUseCase> slotScopeUseCases) {
        this.managedMemoryOperatorScopeUseCaseWeights.putAll(operatorScopeUseCaseWeights);
        this.managedMemorySlotScopeUseCases.addAll(slotScopeUseCases);
    }

    public Map<ManagedMemoryUseCase, Integer> getManagedMemoryOperatorScopeUseCaseWeights() {
        return Collections.unmodifiableMap(this.managedMemoryOperatorScopeUseCaseWeights);
    }

    public Set<ManagedMemoryUseCase> getManagedMemorySlotScopeUseCases() {
        return Collections.unmodifiableSet(this.managedMemorySlotScopeUseCases);
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public void setBufferTimeout(Long bufferTimeout) {
        this.bufferTimeout = bufferTimeout;
    }

    @VisibleForTesting
    public StreamOperator<?> getOperator() {
        return ((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<?> getOperatorFactory() {
        return this.operatorFactory;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setSerializersIn(TypeSerializer<?> ... typeSerializersIn) {
        Preconditions.checkArgument((typeSerializersIn.length > 0 ? 1 : 0) != 0);
        this.typeSerializersIn = typeSerializersIn;
    }

    public TypeSerializer<?>[] getTypeSerializersIn() {
        return this.typeSerializersIn;
    }

    public TypeSerializer<?> getTypeSerializerIn(int index) {
        return this.typeSerializersIn[index];
    }

    public TypeSerializer<?> getTypeSerializerOut() {
        return this.typeSerializerOut;
    }

    public void setSerializerOut(TypeSerializer<?> typeSerializerOut) {
        this.typeSerializerOut = typeSerializerOut;
    }

    public Class<? extends TaskInvokable> getJobVertexClass() {
        return this.jobVertexClass;
    }

    public InputFormat<?, ?> getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(InputFormat<?, ?> inputFormat) {
        this.inputFormat = inputFormat;
    }

    public OutputFormat<?> getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat<?> outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setSlotSharingGroup(@Nullable String slotSharingGroup) {
        this.slotSharingGroup = slotSharingGroup;
    }

    @Nullable
    public String getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    public void setCoLocationGroup(@Nullable String coLocationGroup) {
        this.coLocationGroup = coLocationGroup;
    }

    @Nullable
    public String getCoLocationGroup() {
        return this.coLocationGroup;
    }

    public boolean isSameSlotSharingGroup(StreamNode downstreamVertex) {
        return this.slotSharingGroup == null && downstreamVertex.slotSharingGroup == null || this.slotSharingGroup != null && this.slotSharingGroup.equals(downstreamVertex.slotSharingGroup);
    }

    public String toString() {
        return this.operatorName + "-" + this.id;
    }

    public KeySelector<?, ?>[] getStatePartitioners() {
        return this.statePartitioners;
    }

    public void setStatePartitioners(KeySelector<?, ?> ... statePartitioners) {
        Preconditions.checkArgument((statePartitioners.length > 0 ? 1 : 0) != 0);
        this.statePartitioners = statePartitioners;
    }

    public TypeSerializer<?> getStateKeySerializer() {
        return this.stateKeySerializer;
    }

    public void setStateKeySerializer(TypeSerializer<?> stateKeySerializer) {
        this.stateKeySerializer = stateKeySerializer;
    }

    public String getTransformationUID() {
        return this.transformationUID;
    }

    void setTransformationUID(String transformationId) {
        this.transformationUID = transformationId;
    }

    public String getUserHash() {
        return this.userHash;
    }

    public void setUserHash(String userHash) {
        this.userHash = userHash;
    }

    public void addInputRequirement(int inputIndex, StreamConfig.InputRequirement inputRequirement) {
        this.inputRequirements.put(inputIndex, inputRequirement);
    }

    public Map<Integer, StreamConfig.InputRequirement> getInputRequirements() {
        return this.inputRequirements;
    }

    public Optional<OperatorCoordinator.Provider> getCoordinatorProvider(String operatorName, OperatorID operatorID) {
        if (this.operatorFactory instanceof CoordinatedOperatorFactory) {
            return Optional.of(((CoordinatedOperatorFactory)this.operatorFactory).getCoordinatorProvider(operatorName, operatorID));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamNode that = (StreamNode)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

