/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;
import org.slf4j.LoggerFactory;
import org.sonatype.guice.bean.locators.QualifiedBean;
import org.sonatype.guice.bean.locators.QualifiedBeans;
import org.sonatype.inject.Mediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WatchedBeans<Q extends Annotation, T, W>
extends QualifiedBeans<Q, T>
implements Provider<QualifiedBeans<Q, T>> {
    private final Reference<W> watcherRef;
    private final Mediator<Q, T, W> mediator;

    WatchedBeans(Key<T> key, Mediator<Q, T, W> mediator, W watcher) {
        super(key);
        this.watcherRef = new WeakReference<W>(watcher);
        this.mediator = mediator;
    }

    @Override
    public QualifiedBeans<Q, T> get() {
        return null != this.watcherRef.get() ? this : null;
    }

    @Override
    public synchronized List<QualifiedBean<Q, T>> add(Injector injector) {
        return this.reportBeans(BeanEvent.ADD, super.add(injector));
    }

    @Override
    public synchronized List<QualifiedBean<Q, T>> remove(Injector injector) {
        return this.reportBeans(BeanEvent.REMOVE, super.remove(injector));
    }

    @Override
    public synchronized List<QualifiedBean<Q, T>> clear() {
        return this.reportBeans(BeanEvent.REMOVE, super.clear());
    }

    private List<QualifiedBean<Q, T>> reportBeans(BeanEvent event, List<QualifiedBean<Q, T>> beans) {
        W watcher = this.watcherRef.get();
        if (null != watcher) {
            int size = beans.size();
            for (int i = 0; i < size; ++i) {
                try {
                    event.send(this.mediator, beans.get(i), watcher);
                    continue;
                }
                catch (Throwable e) {
                    this.warn("Problem notifying watcher: " + watcher.getClass(), e);
                }
            }
        }
        return beans;
    }

    private void warn(String message, Throwable cause) {
        try {
            LoggerFactory.getLogger(this.mediator.getClass()).warn(message, cause);
        }
        catch (Throwable ignore) {
            Logger.getLogger(this.mediator.getClass().getName()).log(Level.WARNING, message, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BeanEvent {
        ADD{

            @Override
            public <Q extends Annotation, T, W> void send(Mediator<Q, T, W> mediator, QualifiedBean<Q, T> bean, W watcher) throws Exception {
                mediator.add(bean.getKey(), bean, watcher);
            }
        }
        ,
        REMOVE{

            @Override
            public <Q extends Annotation, T, W> void send(Mediator<Q, T, W> mediator, QualifiedBean<Q, T> bean, W watcher) throws Exception {
                mediator.remove(bean.getKey(), bean, watcher);
            }
        };


        public abstract <Q extends Annotation, T, W> void send(Mediator<Q, T, W> var1, QualifiedBean<Q, T> var2, W var3) throws Exception;
    }
}

