/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.slots;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.util.Preconditions;

public class ResourceRequirements
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobID jobId;
    private final String targetAddress;
    private final Collection<ResourceRequirement> resourceRequirements;

    private ResourceRequirements(JobID jobId, String targetAddress, Collection<ResourceRequirement> resourceRequirements) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.targetAddress = (String)Preconditions.checkNotNull((Object)targetAddress);
        this.resourceRequirements = (Collection)Preconditions.checkNotNull(resourceRequirements);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public Collection<ResourceRequirement> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public static ResourceRequirements create(JobID jobId, String targetAddress, Collection<ResourceRequirement> resourceRequirements) {
        return new ResourceRequirements(jobId, targetAddress, resourceRequirements);
    }

    public static ResourceRequirements empty(JobID jobId, String targetAddress) {
        return new ResourceRequirements(jobId, targetAddress, Collections.emptyList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRequirements that = (ResourceRequirements)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.targetAddress, that.targetAddress) && Objects.equals(this.resourceRequirements, that.resourceRequirements);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.targetAddress, this.resourceRequirements);
    }

    public String toString() {
        return "ResourceRequirements{jobId=" + this.jobId + ", targetAddress='" + this.targetAddress + '\'' + ", resourceRequirements=" + this.resourceRequirements + '}';
    }
}

