/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.AbstractPartitionTracker;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerEntry;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.util.Preconditions;

public class JobMasterPartitionTrackerImpl
extends AbstractPartitionTracker<ResourceID, ResultPartitionDeploymentDescriptor>
implements JobMasterPartitionTracker {
    private final JobID jobId;
    private final ShuffleMaster<?> shuffleMaster;
    private final PartitionTrackerFactory.TaskExecutorGatewayLookup taskExecutorGatewayLookup;

    public JobMasterPartitionTrackerImpl(JobID jobId, ShuffleMaster<?> shuffleMaster, PartitionTrackerFactory.TaskExecutorGatewayLookup taskExecutorGatewayLookup) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.shuffleMaster = (ShuffleMaster)Preconditions.checkNotNull(shuffleMaster);
        this.taskExecutorGatewayLookup = taskExecutorGatewayLookup;
    }

    @Override
    public void startTrackingPartition(ResourceID producingTaskExecutorId, ResultPartitionDeploymentDescriptor resultPartitionDeploymentDescriptor) {
        Preconditions.checkNotNull((Object)producingTaskExecutorId);
        Preconditions.checkNotNull((Object)resultPartitionDeploymentDescriptor);
        if (!resultPartitionDeploymentDescriptor.getPartitionType().isReconnectable()) {
            return;
        }
        ResultPartitionID resultPartitionId = resultPartitionDeploymentDescriptor.getShuffleDescriptor().getResultPartitionID();
        this.startTrackingPartition(producingTaskExecutorId, resultPartitionId, resultPartitionDeploymentDescriptor);
    }

    @Override
    void startTrackingPartition(ResourceID key, ResultPartitionID resultPartitionId, ResultPartitionDeploymentDescriptor metaInfo) {
        if (metaInfo.getShuffleDescriptor().storesLocalResourcesOn().isPresent()) {
            this.partitionTable.startTrackingPartitions(key, Collections.singletonList(resultPartitionId));
        }
        this.partitionInfos.put(resultPartitionId, new AbstractPartitionTracker.PartitionInfo<ResourceID, ResultPartitionDeploymentDescriptor>(key, metaInfo));
    }

    @Override
    public void stopTrackingAndReleasePartitions(Collection<ResultPartitionID> resultPartitionIds, boolean releaseOnShuffleMaster) {
        this.stopTrackingAndHandlePartitions(resultPartitionIds, (tmID, partitionDescs) -> this.internalReleasePartitions((ResourceID)tmID, (Collection<ResultPartitionDeploymentDescriptor>)partitionDescs, releaseOnShuffleMaster));
    }

    @Override
    public void stopTrackingAndReleaseOrPromotePartitions(Collection<ResultPartitionID> resultPartitionIds) {
        this.stopTrackingAndHandlePartitions(resultPartitionIds, (tmID, partitionDescs) -> this.internalReleaseOrPromotePartitions((ResourceID)tmID, (Collection<ResultPartitionDeploymentDescriptor>)partitionDescs));
    }

    @Override
    public Collection<ResultPartitionDeploymentDescriptor> getAllTrackedPartitions() {
        return this.partitionInfos.values().stream().map(AbstractPartitionTracker.PartitionInfo::getMetaInfo).collect(Collectors.toList());
    }

    private void stopTrackingAndHandlePartitions(Collection<ResultPartitionID> resultPartitionIds, BiConsumer<ResourceID, Collection<ResultPartitionDeploymentDescriptor>> partitionHandler) {
        Preconditions.checkNotNull(resultPartitionIds);
        Map partitionsToReleaseByResourceId = this.stopTrackingPartitions(resultPartitionIds).stream().collect(Collectors.groupingBy(PartitionTrackerEntry::getKey, Collectors.mapping(PartitionTrackerEntry::getMetaInfo, Collectors.toList())));
        partitionsToReleaseByResourceId.forEach(partitionHandler);
    }

    private void internalReleasePartitions(ResourceID potentialPartitionLocation, Collection<ResultPartitionDeploymentDescriptor> partitionDeploymentDescriptors, boolean releaseOnShuffleMaster) {
        this.internalReleasePartitionsOnTaskExecutor(potentialPartitionLocation, partitionDeploymentDescriptors);
        if (releaseOnShuffleMaster) {
            this.internalReleasePartitionsOnShuffleMaster(partitionDeploymentDescriptors.stream());
        }
    }

    private void internalReleaseOrPromotePartitions(ResourceID potentialPartitionLocation, Collection<ResultPartitionDeploymentDescriptor> partitionDeploymentDescriptors) {
        this.internalReleaseOrPromotePartitionsOnTaskExecutor(potentialPartitionLocation, partitionDeploymentDescriptors);
        this.internalReleasePartitionsOnShuffleMaster(JobMasterPartitionTrackerImpl.excludePersistentPartitions(partitionDeploymentDescriptors));
    }

    private void internalReleasePartitionsOnTaskExecutor(ResourceID potentialPartitionLocation, Collection<ResultPartitionDeploymentDescriptor> partitionDeploymentDescriptors) {
        Set<ResultPartitionID> partitionsRequiringRpcReleaseCalls = partitionDeploymentDescriptors.stream().filter(JobMasterPartitionTrackerImpl::isPartitionWithLocalResources).map(JobMasterPartitionTrackerImpl::getResultPartitionId).collect(Collectors.toSet());
        this.internalReleaseOrPromotePartitionsOnTaskExecutor(potentialPartitionLocation, partitionsRequiringRpcReleaseCalls, Collections.emptySet());
    }

    private void internalReleaseOrPromotePartitionsOnTaskExecutor(ResourceID potentialPartitionLocation, Collection<ResultPartitionDeploymentDescriptor> partitionDeploymentDescriptors) {
        Map partitionsToReleaseByPersistence = partitionDeploymentDescriptors.stream().filter(JobMasterPartitionTrackerImpl::isPartitionWithLocalResources).collect(Collectors.partitioningBy(resultPartitionDeploymentDescriptor -> resultPartitionDeploymentDescriptor.getPartitionType().isPersistent(), Collectors.mapping(JobMasterPartitionTrackerImpl::getResultPartitionId, Collectors.toSet())));
        this.internalReleaseOrPromotePartitionsOnTaskExecutor(potentialPartitionLocation, partitionsToReleaseByPersistence.get(false), partitionsToReleaseByPersistence.get(true));
    }

    private void internalReleaseOrPromotePartitionsOnTaskExecutor(ResourceID potentialPartitionLocation, Set<ResultPartitionID> partitionsRequiringRpcReleaseCalls, Set<ResultPartitionID> partitionsRequiringRpcPromoteCalls) {
        if (!partitionsRequiringRpcReleaseCalls.isEmpty() || !partitionsRequiringRpcPromoteCalls.isEmpty()) {
            this.taskExecutorGatewayLookup.lookup(potentialPartitionLocation).ifPresent(taskExecutorGateway -> taskExecutorGateway.releaseOrPromotePartitions(this.jobId, partitionsRequiringRpcReleaseCalls, partitionsRequiringRpcPromoteCalls));
        }
    }

    private void internalReleasePartitionsOnShuffleMaster(Stream<ResultPartitionDeploymentDescriptor> partitionDeploymentDescriptors) {
        partitionDeploymentDescriptors.map(ResultPartitionDeploymentDescriptor::getShuffleDescriptor).forEach(this.shuffleMaster::releasePartitionExternally);
    }

    private static boolean isPartitionWithLocalResources(ResultPartitionDeploymentDescriptor resultPartitionDeploymentDescriptor) {
        return resultPartitionDeploymentDescriptor.getShuffleDescriptor().storesLocalResourcesOn().isPresent();
    }

    private static Stream<ResultPartitionDeploymentDescriptor> excludePersistentPartitions(Collection<ResultPartitionDeploymentDescriptor> partitionDeploymentDescriptors) {
        return partitionDeploymentDescriptors.stream().filter(resultPartitionDeploymentDescriptor -> !resultPartitionDeploymentDescriptor.getPartitionType().isPersistent());
    }

    private static ResultPartitionID getResultPartitionId(ResultPartitionDeploymentDescriptor resultPartitionDeploymentDescriptor) {
        return resultPartitionDeploymentDescriptor.getShuffleDescriptor().getResultPartitionID();
    }
}

