/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.digest.DigestUtils;

public class EncryptUtils {
    private static final int KEY_SIZE = 128;
    private static final String DEFAULT_KEY = DigestUtils.md5Hex((String)"ApacheStreamPark");
    private static final String ALGORITHM = "AES";
    private static final String RNG_ALGORITHM = "SHA1PRNG";

    private EncryptUtils() {
    }

    public static String encrypt(String content) throws Exception {
        return EncryptUtils.encrypt(content, DEFAULT_KEY);
    }

    public static String encrypt(String content, String key) throws Exception {
        Cipher cipher = EncryptUtils.getCipher(1, key);
        byte[] bytes = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String decrypt(String content) throws Exception {
        return EncryptUtils.decrypt(content, DEFAULT_KEY);
    }

    public static String decrypt(String content, String key) throws Exception {
        Cipher cipher = EncryptUtils.getCipher(2, key);
        byte[] base64 = Base64.getDecoder().decode(content);
        byte[] decryptBytes = cipher.doFinal(base64);
        return new String(decryptBytes, StandardCharsets.UTF_8);
    }

    private static Cipher getCipher(int mode, String key) throws Exception {
        SecureRandom random = SecureRandom.getInstance(RNG_ALGORITHM);
        random.setSeed(key.getBytes(StandardCharsets.UTF_8));
        KeyGenerator gen = KeyGenerator.getInstance(ALGORITHM);
        gen.init(128, random);
        SecretKey secKey = gen.generateKey();
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(mode, secKey);
        return cipher;
    }
}

