/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.streampark.common.util.HadoopUtils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.exception.PermissionDeniedException;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.enums.UserType;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.ProxyService;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.core.task.FlinkK8sWatcherWrapper;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.Member;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.MemberService;
import org.apache.streampark.console.system.service.UserService;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ProxyServiceImpl
implements ProxyService {
    private static final Logger log = LoggerFactory.getLogger(ProxyServiceImpl.class);
    @Autowired
    private ServiceHelper serviceHelper;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ApplicationLogService logService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlinkK8sWatcher flinkK8sWatcher;
    @Autowired
    private FlinkK8sWatcherWrapper k8sWatcherWrapper;
    private final RestTemplate proxyRestTemplate;
    private String httpAuthUsername = "";

    public ProxyServiceImpl(RestTemplateBuilder restTemplateBuilder) {
        this.proxyRestTemplate = restTemplateBuilder.errorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(@Nonnull ClientHttpResponse response) {
            }
        }).build();
    }

    @Override
    public ResponseEntity<?> proxyFlink(HttpServletRequest request, Long appId) throws Exception {
        ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
        Application app = (Application)this.applicationService.getById(appId);
        this.checkProxyApp(app);
        String url = null;
        switch (app.getExecutionModeEnum()) {
            case YARN_PER_JOB: 
            case YARN_APPLICATION: 
            case YARN_SESSION: {
                String yarnURL = YarnUtils.getRMWebAppProxyURL();
                url = yarnURL + "/proxy/" + app.getClusterId();
                url = url + this.getRequestURL(request, "/proxy/flink/" + appId);
                return this.proxyYarnRequest(request, url);
            }
            case REMOTE: {
                FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(app.getFlinkClusterId());
                url = cluster.getAddress();
                break;
            }
            case KUBERNETES_NATIVE_APPLICATION: 
            case KUBERNETES_NATIVE_SESSION: {
                url = this.flinkK8sWatcher.getRemoteRestUrl(this.k8sWatcherWrapper.toTrackId(app));
            }
        }
        if (url == null) {
            ResponseEntity.BodyBuilder builder = ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
            builder.body((Object)"The flink job manager url is not ready");
            return builder.build();
        }
        url = url + this.getRequestURL(request, "/proxy/flink/" + appId);
        return this.proxyRequest(request, url);
    }

    @Override
    public ResponseEntity<?> proxyYarn(HttpServletRequest request, Long logId) throws Exception {
        ResponseEntity.BodyBuilder builder = ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
        ApplicationLog log = (ApplicationLog)this.logService.getById(logId);
        if (log == null) {
            return builder.body((Object)"The application log not found.");
        }
        this.checkProxyAppLog(log);
        String yarnId = log.getYarnAppId();
        String yarnURL = YarnUtils.getRMWebAppProxyURL();
        String url = yarnURL + "/proxy/" + yarnId + "/";
        url = url + this.getRequestURL(request, "/proxy/yarn/" + logId);
        return this.proxyYarnRequest(request, url);
    }

    @Override
    public ResponseEntity<?> proxyHistory(HttpServletRequest request, Long logId) throws Exception {
        ResponseEntity.BodyBuilder builder = ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
        ApplicationLog log = (ApplicationLog)this.logService.getById(logId);
        if (log == null) {
            return builder.body((Object)"The application log not found.");
        }
        this.checkProxyAppLog(log);
        String url = log.getJobManagerUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            return builder.body((Object)"The jobManager url is null.");
        }
        url = url + this.getRequestURL(request, "/proxy/history/" + logId);
        return this.proxyRequest(request, url);
    }

    @Override
    public ResponseEntity<?> proxyCluster(HttpServletRequest request, Long clusterId) throws Exception {
        ResponseEntity.BodyBuilder builder = ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
        FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(clusterId);
        if (cluster == null) {
            return builder.body((Object)"The cluster not found.");
        }
        String url = cluster.getAddress();
        if (StringUtils.isBlank((CharSequence)url)) {
            return builder.body((Object)"The cluster address is invalid.");
        }
        url = url + this.getRequestURL(request, "/proxy/cluster/" + clusterId);
        return this.proxyRequest(request, url);
    }

    public void checkProxyApp(Application app) {
        Member member;
        User user;
        Long userId;
        if (app == null) {
            throw new PermissionDeniedException("Invalid operation, application is invalid.");
        }
        String token = this.serviceHelper.getAuthorization();
        if (token != null && (userId = JWTUtil.getUserId(token)) != null && !userId.equals(app.getUserId()) && (user = (User)this.userService.getById(userId)) != null && user.getUserType() != UserType.ADMIN && (member = this.memberService.findByUserId(app.getTeamId(), userId)) == null) {
            throw new PermissionDeniedException("Permission denied, this job not created by the current user, And the job cannot be found in the current user's team.");
        }
    }

    public void checkProxyAppLog(ApplicationLog log) {
        if (log == null) {
            throw new PermissionDeniedException("Invalid operation, The application log not found.");
        }
        Application app = (Application)this.applicationService.getById(log.getAppId());
        this.checkProxyApp(app);
    }

    private HttpEntity<?> getRequestEntity(HttpServletRequest request, String url) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.set(headerName, request.getHeader(headerName));
        }
        URI uri = new URI(url);
        headers.set("Host", uri.getHost());
        byte[] body = null;
        if (request.getInputStream().available() > 0) {
            ServletInputStream inputStream = request.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            body = byteArrayOutputStream.toByteArray();
        }
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    private ResponseEntity<?> proxyRequest(HttpServletRequest request, String url) throws Exception {
        return this.proxy(request, url, this.getRequestEntity(request, url));
    }

    private ResponseEntity<?> proxyYarnRequest(HttpServletRequest request, String url) throws Exception {
        if (YarnUtils.hasYarnHttpKerberosAuth()) {
            UserGroupInformation ugi = HadoopUtils.getUgi();
            HttpEntity<?> requestEntity = this.getRequestEntity(request, url);
            this.setRestTemplateCredentials(ugi.getShortUserName());
            return (ResponseEntity)ugi.doAs(() -> this.proxy(request, url, requestEntity));
        }
        return this.proxyRequest(request, url);
    }

    private ResponseEntity<?> proxy(HttpServletRequest request, String url, HttpEntity<?> requestEntity) {
        try {
            return this.proxyRestTemplate.exchange(url, HttpMethod.valueOf((String)request.getMethod()), requestEntity, byte[].class, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("Proxy url: {} failed. ", (Object)url, (Object)e);
            return new ResponseEntity(HttpStatus.BAD_GATEWAY);
        }
    }

    private String getRequestURL(HttpServletRequest request, String replaceString) {
        String url = request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
        return url.replace(replaceString, "");
    }

    private void setRestTemplateCredentials(String username) {
        if (username != null && !this.httpAuthUsername.equals(username)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, null));
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            this.proxyRestTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient));
            this.httpAuthUsername = username;
        }
    }
}

