/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;

public final class RegExpUtils$ {
    public static final RegExpUtils$ MODULE$ = new RegExpUtils$();

    public String initLastMatcherCode(CodegenContext ctx, String subject, String regexp, String matcher, String prettyName, int collationId) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        int collationRegexFlags = CollationSupport.collationAwareRegexFlags((int)collationId);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |if (!" + regexp + ".equals(" + termLastRegex + ")) {\n       |  // regex value changed\n       |  try {\n       |    UTF8String r = " + regexp + ".clone();\n       |    " + termPattern + " = " + classNamePattern + ".compile(r.toString(), " + collationRegexFlags + ");\n       |    " + termLastRegex + " = r;\n       |  } catch (java.util.regex.PatternSyntaxException e) {\n       |    throw QueryExecutionErrors.invalidPatternError(\"" + prettyName + "\", e.getPattern(), e);\n       |  }\n       |}\n       |java.util.regex.Matcher " + matcher + " = " + termPattern + ".matcher(" + subject + ".toString());\n       |"));
    }

    public Tuple2<Pattern, UTF8String> getPatternAndLastRegex(Object p, String prettyName, int collationId) {
        Pattern pattern;
        UTF8String r = ((UTF8String)p).clone();
        try {
            pattern = Pattern.compile(r.toString(), CollationSupport.collationAwareRegexFlags((int)collationId));
        }
        catch (PatternSyntaxException e) {
            throw QueryExecutionErrors$.MODULE$.invalidPatternError(prettyName, e.getPattern(), e);
        }
        Pattern pattern2 = pattern;
        return new Tuple2((Object)pattern2, (Object)r);
    }

    private RegExpUtils$() {
    }
}

