/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ImmutableValueMap
implements ValueMap {
    private final ValueMap map;

    ImmutableValueMap(@NotNull ValueMap map) {
        this.map = map;
    }

    ImmutableValueMap(@NotNull Map<String, Object> map) {
        this.map = new ValueMapDecorator(map);
    }

    @Nullable
    public <T> T get(@NotNull String name, @NotNull Class<T> type) {
        return (T)this.map.get(name, type);
    }

    @NotNull
    public <T> T get(@NotNull String name, @NotNull T defaultValue) {
        return (T)this.map.get(name, defaultValue);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutableValueMap)) {
            return false;
        }
        return this.map.entrySet().equals(((ImmutableValueMap)obj).map.entrySet());
    }

    public String toString() {
        return this.map.toString();
    }

    @Deprecated
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static ImmutableValueMap of() {
        return new ImmutableValueMap(ValueMap.EMPTY);
    }

    @NotNull
    public static ImmutableValueMap of(@NotNull String k1, @NotNull Object v1) {
        return new ImmutableValueMap(Collections.singletonMap(k1, v1));
    }

    @NotNull
    public static ImmutableValueMap of(@NotNull String k1, @NotNull Object v1, @NotNull String k2, @NotNull Object v2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(k1, v1);
        map.put(k2, v2);
        return new ImmutableValueMap(map);
    }

    @NotNull
    public static ImmutableValueMap of(@NotNull String k1, @NotNull Object v1, @NotNull String k2, @NotNull Object v2, @NotNull String k3, @NotNull Object v3) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return new ImmutableValueMap(map);
    }

    @NotNull
    public static ImmutableValueMap of(@NotNull String k1, @NotNull Object v1, @NotNull String k2, @NotNull Object v2, @NotNull String k3, @NotNull Object v3, @NotNull String k4, @NotNull Object v4) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return new ImmutableValueMap(map);
    }

    public static ImmutableValueMap of(@NotNull String k1, @NotNull Object v1, @NotNull String k2, @NotNull Object v2, @NotNull String k3, @NotNull Object v3, @NotNull String k4, @NotNull Object v4, @NotNull String k5, @NotNull Object v5) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return new ImmutableValueMap(map);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static ImmutableValueMap copyOf(@NotNull Map<String, Object> map) {
        if (map instanceof ValueMap) {
            ValueMap valueMap = (ValueMap)map;
            return new ImmutableValueMap(valueMap);
        }
        return new ImmutableValueMap(map);
    }

    public static final class Builder {
        @NotNull
        private final Map<String, Object> map = new HashMap<String, Object>();

        @NotNull
        public Builder put(@NotNull String key, @NotNull Object value) {
            this.map.put(key, value);
            return this;
        }

        @NotNull
        public Builder put(@NotNull Map.Entry<String, Object> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        @NotNull
        public Builder putAll(@NotNull Map<String, Object> value) {
            this.map.putAll(value);
            return this;
        }

        @NotNull
        public ImmutableValueMap build() {
            if (this.map.isEmpty()) {
                return ImmutableValueMap.of();
            }
            return new ImmutableValueMap(this.map);
        }
    }
}

