/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query.fulltext;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;

public class FullTextOr
extends FullTextExpression {
    public final List<FullTextExpression> list;

    public FullTextOr(List<FullTextExpression> list) {
        this.list = list;
    }

    @Override
    public boolean evaluate(String value) {
        for (FullTextExpression e : this.list) {
            if (!e.evaluate(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FullTextExpression simplify() {
        Set<FullTextExpression> set = FullTextOr.getUniqueSet(this.list);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        ArrayList<FullTextExpression> l = new ArrayList<FullTextExpression>(set.size());
        l.addAll(set);
        return new FullTextOr(l);
    }

    static Set<FullTextExpression> getUniqueSet(List<FullTextExpression> list) {
        LinkedHashSet<FullTextExpression> set = new LinkedHashSet<FullTextExpression>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            set.add(list.get(i).simplify());
        }
        return set;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        for (FullTextExpression e : this.list) {
            if (i++ > 0) {
                buff.append(" OR ");
            }
            if (e.getPrecedence() < this.getPrecedence()) {
                buff.append('(');
            }
            buff.append(e.toString());
            if (e.getPrecedence() >= this.getPrecedence()) continue;
            buff.append(')');
        }
        return buff.toString();
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public boolean accept(FullTextVisitor v) {
        return v.visit(this);
    }
}

