/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingPropertiesPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingPropertiesPrinter.class);
    private static String HEADLINE = "Apache Sling Launchpad Properties";
    private final Properties props;

    public static void init(BundleContext bundleContext) throws IOException {
        Properties props;
        block10: {
            String propUrl = bundleContext.getProperty("sling.properties.url");
            if (propUrl != null) {
                try (InputStream is = new URL(propUrl).openStream();){
                    Properties tmp = new Properties();
                    tmp.load(is);
                    for (Object key : tmp.keySet()) {
                        String value = bundleContext.getProperty(key.toString());
                        if (value == null) continue;
                        tmp.put(key, value);
                    }
                    props = tmp;
                    break block10;
                }
                catch (IOException ioe) {
                    LOGGER.error("Unable to read sling properties from '{}'", (Object)propUrl, (Object)ioe);
                    return;
                }
            }
            LOGGER.debug("No bundle context property 'sling.properties.url' provided, not starting 'slingprops' webconsole plugin!");
            return;
        }
        SlingPropertiesPrinter propertiesPrinter = new SlingPropertiesPrinter(props);
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("felix.webconsole.label", "slingprops");
        ((Dictionary)serviceProps).put("felix.webconsole.title", "Sling Properties");
        ((Dictionary)serviceProps).put("felix.webconsole.configprinter.modes", "always");
        bundleContext.registerService(SlingPropertiesPrinter.class.getName(), (Object)propertiesPrinter, serviceProps);
    }

    public SlingPropertiesPrinter(Properties props) throws IOException {
        this.props = props;
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println(HEADLINE);
        pw.println();
        TreeSet<Object> keys = new TreeSet<Object>(this.props.keySet());
        for (Object e : keys) {
            pw.print(e);
            pw.print(" = ");
            Object value = this.props.get(e);
            if (value != null) {
                pw.print(value.toString());
            }
            pw.println();
        }
    }

    public void printConfiguration(PrintWriter printWriter, String mode) {
        if (!"zip".equals(mode)) {
            this.printConfiguration(printWriter);
        } else {
            String contents = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.props.store(baos, HEADLINE);
                contents = baos.toString("8859_1");
            }
            catch (IOException ioe) {
                this.printConfiguration(printWriter);
                return;
            }
            printWriter.write(contents);
        }
    }
}

