/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.login.impl;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.auth.xing.login.XingLoginUserManager;
import org.apache.sling.auth.xing.login.XingLoginUtil;
import org.apache.sling.jcr.jackrabbit.server.security.AuthenticationPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XingLoginAuthenticationPlugin
implements AuthenticationPlugin {
    private final XingLoginUserManager xingLoginUserManager;
    private final Logger logger = LoggerFactory.getLogger(XingLoginAuthenticationPlugin.class);

    public XingLoginAuthenticationPlugin(XingLoginUserManager xingLoginUserManager) {
        this.xingLoginUserManager = xingLoginUserManager;
    }

    public boolean authenticate(Credentials credentials) throws RepositoryException {
        this.logger.debug("authenticate");
        String givenHash = XingLoginUtil.getHash(credentials);
        if (givenHash == null) {
            this.logger.debug("unable to get hash from given credentials");
            return false;
        }
        User user = this.xingLoginUserManager.getUser(credentials);
        if (user == null) {
            this.logger.debug("no user found for given credentials");
            if (this.xingLoginUserManager.autoCreate()) {
                this.logger.debug("creating a new user from given user data");
                user = this.xingLoginUserManager.createUser(credentials);
            }
        }
        if (user == null) {
            return false;
        }
        String storedHash = this.xingLoginUserManager.getHash(user);
        if (storedHash == null) {
            this.logger.debug("no hash found for user '{}'", (Object)user.getID());
            return false;
        }
        if (givenHash.equals(storedHash)) {
            this.logger.debug("hashes for user '{}' do match", (Object)user.getID());
            return true;
        }
        this.logger.debug("hashes for user '{}' do not match", (Object)user.getID());
        if (this.xingLoginUserManager.autoUpdate()) {
            this.logger.debug("updating an existing user from given user data");
            return this.xingLoginUserManager.updateUser(credentials) != null;
        }
        return false;
    }
}

