/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;

public class DBLatencyThresholdsAndWatcher
extends ConfigChangeWatcher {
    private AtomicReference<Map<String, Integer>> thresholds = new AtomicReference(new HashMap());
    private final String initialSettingsString;
    private volatile String dynamicSettingsString;

    public DBLatencyThresholdsAndWatcher(String config, ModuleProvider provider) {
        super("agent-analyzer", provider, "slowDBAccessThreshold");
        this.initialSettingsString = config;
        this.activeSetting(config);
    }

    private void activeSetting(String config) {
        String[] settings;
        HashMap<String, Integer> newThresholds = new HashMap<String, Integer>();
        for (String setting : settings = config.split(",")) {
            String[] typeValue = setting.split(":");
            if (typeValue.length != 2) continue;
            newThresholds.put(typeValue[0].trim().toLowerCase(), Integer.parseInt(typeValue[1].trim()));
        }
        this.thresholds.set(newThresholds);
    }

    public int getThreshold(String type) {
        type = type.toLowerCase();
        if (this.thresholds.get().containsKey(type)) {
            return this.thresholds.get().get(type);
        }
        return Optional.ofNullable(this.thresholds.get().get("default")).orElse(Integer.MAX_VALUE);
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.dynamicSettingsString = null;
            this.activeSetting(this.initialSettingsString);
        } else {
            this.dynamicSettingsString = value.getNewValue();
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.dynamicSettingsString;
    }
}

