/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.execution.TypeFromAST;
import graphql.execution.ValuesResolver;
import graphql.language.OperationDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.InputValueWithState;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import graphql.validation.rules.VariablesTypesMatcher;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@Internal
public class VariableTypesMatch
extends AbstractRule {
    final VariablesTypesMatcher variablesTypesMatcher;
    private Map<String, VariableDefinition> variableDefinitionMap;

    public VariableTypesMatch(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        this(validationContext, validationErrorCollector, new VariablesTypesMatcher());
    }

    VariableTypesMatch(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector, VariablesTypesMatcher variablesTypesMatcher) {
        super(validationContext, validationErrorCollector);
        this.setVisitFragmentSpreads(true);
        this.variablesTypesMatcher = variablesTypesMatcher;
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        this.variableDefinitionMap = new LinkedHashMap<String, VariableDefinition>();
    }

    @Override
    public void checkVariableDefinition(VariableDefinition variableDefinition) {
        this.variableDefinitionMap.put(variableDefinition.getName(), variableDefinition);
    }

    @Override
    public void checkVariable(VariableReference variableReference) {
        VariableDefinition variableDefinition = this.variableDefinitionMap.get(variableReference.getName());
        if (variableDefinition == null) {
            return;
        }
        GraphQLType variableType = TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), variableDefinition.getType());
        if (variableType == null) {
            return;
        }
        GraphQLInputType locationType = this.getValidationContext().getInputType();
        Optional<InputValueWithState> locationDefault = Optional.ofNullable(this.getValidationContext().getDefaultValue());
        if (locationType == null) {
            return;
        }
        Value<?> locationDefaultValue = null;
        if (locationDefault.isPresent() && locationDefault.get().isLiteral()) {
            locationDefaultValue = (Value<?>)locationDefault.get().getValue();
        } else if (locationDefault.isPresent() && locationDefault.get().isSet()) {
            locationDefaultValue = ValuesResolver.valueToLiteral(locationDefault.get(), locationType, this.getValidationContext().getGraphQLContext(), this.getValidationContext().getI18n().getLocale());
        }
        boolean variableDefMatches = this.variablesTypesMatcher.doesVariableTypesMatch(variableType, variableDefinition.getDefaultValue(), locationType, locationDefaultValue);
        if (!variableDefMatches) {
            GraphQLType effectiveType = this.variablesTypesMatcher.effectiveType(variableType, variableDefinition.getDefaultValue());
            String message = this.i18n(ValidationErrorType.VariableTypeMismatch, "VariableTypesMatchRule.unexpectedType", variableDefinition.getName(), GraphQLTypeUtil.simplePrint(effectiveType), GraphQLTypeUtil.simplePrint(locationType));
            this.addError(ValidationErrorType.VariableTypeMismatch, variableReference.getSourceLocation(), message);
        }
    }
}

