/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class GraphQLEnumType
implements GraphQLNamedInputType,
GraphQLNamedOutputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final ImmutableMap<String, GraphQLEnumValueDefinition> valueDefinitionMap;
    private final EnumTypeDefinition definition;
    private final ImmutableList<EnumTypeExtensionDefinition> extensionDefinitions;
    private final DirectivesUtil.DirectivesHolder directivesHolder;
    public static final String CHILD_VALUES = "values";

    @Internal
    private GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, EnumTypeDefinition definition, List<EnumTypeExtensionDefinition> extensionDefinitions) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.extensionDefinitions = ImmutableList.copyOf(extensionDefinitions);
        this.directivesHolder = new DirectivesUtil.DirectivesHolder(directives, appliedDirectives);
        this.valueDefinitionMap = this.buildMap(values);
    }

    @Internal
    @Deprecated
    public Object serialize(Object input) {
        return this.serialize(input, GraphQLContext.getDefault(), Locale.getDefault());
    }

    @Internal
    public Object serialize(Object input, GraphQLContext graphQLContext, Locale locale) {
        return this.getNameByValue(input, graphQLContext, locale);
    }

    @Internal
    @Deprecated
    public Object parseValue(Object input) {
        return this.getValueByName(input, GraphQLContext.getDefault(), Locale.getDefault());
    }

    @Internal
    public Object parseValue(Object input, GraphQLContext graphQLContext, Locale locale) {
        return this.getValueByName(input, graphQLContext, locale);
    }

    @Internal
    @Deprecated
    public Object parseLiteral(Object input) {
        return this.parseLiteralImpl(input, GraphQLContext.getDefault(), Locale.getDefault());
    }

    @Internal
    public Object parseLiteral(Value<?> input, GraphQLContext graphQLContext, Locale locale) {
        return this.parseLiteralImpl(input, graphQLContext, locale);
    }

    private Object parseLiteralImpl(Object input, GraphQLContext graphQLContext, Locale locale) {
        if (!(input instanceof EnumValue)) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Scalar.unexpectedAstType", "EnumValue", CoercingUtil.typeName(input)));
        }
        EnumValue enumValue = (EnumValue)input;
        GraphQLEnumValueDefinition enumValueDefinition = this.valueDefinitionMap.get(enumValue.getName());
        if (enumValueDefinition == null) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Enum.unallowableValue", this.getName(), input));
        }
        return enumValueDefinition.getValue();
    }

    @Internal
    @Deprecated
    public Value valueToLiteral(Object input) {
        return this.valueToLiteral(input, GraphQLContext.getDefault(), Locale.getDefault());
    }

    @Internal
    public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
        GraphQLEnumValueDefinition enumValueDefinition = this.valueDefinitionMap.get(input.toString());
        Assert.assertNotNull(enumValueDefinition, () -> CoercingUtil.i18nMsg(locale, "Enum.badName", this.name, input.toString()));
        return EnumValue.newEnumValue(enumValueDefinition.getName()).build();
    }

    public List<GraphQLEnumValueDefinition> getValues() {
        return ImmutableList.copyOf(this.valueDefinitionMap.values());
    }

    public GraphQLEnumValueDefinition getValue(String name) {
        return this.valueDefinitionMap.get(name);
    }

    private ImmutableMap<String, GraphQLEnumValueDefinition> buildMap(List<GraphQLEnumValueDefinition> values) {
        return ImmutableMap.copyOf(FpKit.getByName(values, GraphQLEnumValueDefinition::getName, (fld1, fld2) -> (GraphQLEnumValueDefinition)Assert.assertShouldNeverHappen("Duplicated definition for field '%s' in type '%s'", fld1.getName(), this.name)));
    }

    private Object getValueByName(@NotNull Object value, GraphQLContext graphQLContext, Locale locale) {
        GraphQLEnumValueDefinition enumValueDefinition = this.valueDefinitionMap.get(value.toString());
        if (enumValueDefinition != null) {
            return enumValueDefinition.getValue();
        }
        throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Enum.badName", this.name, value.toString()));
    }

    private Object getNameByValue(Object value, GraphQLContext graphQLContext, Locale locale) {
        for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
            Object definitionValue = valueDefinition.getValue();
            if (value.equals(definitionValue)) {
                return valueDefinition.getName();
            }
            if (!(definitionValue instanceof Enum) || !(value instanceof String) || !value.equals(((Enum)definitionValue).name())) continue;
            return valueDefinition.getName();
        }
        if (value instanceof Enum) {
            String enumNameValue = ((Enum)value).name();
            for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
                String definitionValue = String.valueOf(valueDefinition.getValue());
                if (!enumNameValue.equals(definitionValue)) continue;
                return valueDefinition.getName();
            }
        }
        throw new CoercingSerializeException(CoercingUtil.i18nMsg(locale, "Enum.badInput", this.name, value));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EnumTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<EnumTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directivesHolder.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directivesHolder.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directivesHolder.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directivesHolder.getDirective(directiveName);
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directivesHolder.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directivesHolder.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directivesHolder.getAppliedDirective(directiveName);
    }

    public GraphQLEnumType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLEnumType.newEnum(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLEnumType.newEnum(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLEnumType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.valueDefinitionMap.values());
        children.addAll(this.directivesHolder.getDirectives());
        children.addAll(this.directivesHolder.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_VALUES, this.valueDefinitionMap.values()).children("directives", this.directivesHolder.getDirectives()).children("appliedDirectives", this.directivesHolder.getAppliedDirectives()).build();
    }

    @Override
    public GraphQLEnumType withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceValues(newChildren.getChildren(CHILD_VALUES)).replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives")));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "GraphQLEnumType{name='" + this.name + "', description='" + this.description + "', valueDefinitionMap=" + this.valueDefinitionMap + ", definition=" + this.definition + ", extensionDefinitions=" + this.extensionDefinitions + ", directives=" + this.directivesHolder + "}";
    }

    public static Builder newEnum() {
        return new Builder();
    }

    public static Builder newEnum(GraphQLEnumType existing) {
        return new Builder(existing);
    }

    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private EnumTypeDefinition definition;
        private List<EnumTypeExtensionDefinition> extensionDefinitions = ImmutableKit.emptyList();
        private final Map<String, GraphQLEnumValueDefinition> values = new LinkedHashMap<String, GraphQLEnumValueDefinition>();

        public Builder() {
        }

        public Builder(GraphQLEnumType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.values.putAll(FpKit.getByName(existing.getValues(), GraphQLEnumValueDefinition::getName));
            this.copyExistingDirectives(existing);
        }

        public Builder definition(EnumTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<EnumTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder value(String name, Object value, String description, String deprecationReason) {
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).description(description).value(value).deprecationReason(deprecationReason).build());
        }

        public Builder value(String name, Object value, String description) {
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).description(description).value(value).build());
        }

        public Builder value(String name, Object value) {
            Assert.assertNotNull(value, () -> "value can't be null");
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).value(value).build());
        }

        public Builder value(String name) {
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).value(name).build());
        }

        public Builder values(List<GraphQLEnumValueDefinition> valueDefinitions) {
            valueDefinitions.forEach(this::value);
            return this;
        }

        public Builder replaceValues(List<GraphQLEnumValueDefinition> valueDefinitions) {
            this.values.clear();
            valueDefinitions.forEach(this::value);
            return this;
        }

        public Builder value(GraphQLEnumValueDefinition enumValueDefinition) {
            Assert.assertNotNull(enumValueDefinition, () -> "enumValueDefinition can't be null");
            this.values.put(enumValueDefinition.getName(), enumValueDefinition);
            return this;
        }

        public boolean hasValue(String name) {
            return this.values.containsKey(name);
        }

        public Builder clearValues() {
            this.values.clear();
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLEnumType build() {
            return new GraphQLEnumType(this.name, this.description, this.sort(this.values, GraphQLEnumType.class, GraphQLEnumValueDefinition.class), this.sort(this.directives, GraphQLEnumType.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLScalarType.class, GraphQLAppliedDirective.class), this.definition, this.extensionDefinitions);
        }
    }
}

