/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.language.SelectionSetContainer;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;

@Internal
class QueryTraversalContext {
    private final GraphQLOutputType outputType;
    private final QueryVisitorFieldEnvironment environment;
    private final SelectionSetContainer<?> selectionSetContainer;
    private final GraphQLContext graphQLContext;

    QueryTraversalContext(GraphQLOutputType outputType, QueryVisitorFieldEnvironment environment, SelectionSetContainer<?> selectionSetContainer, GraphQLContext graphQLContext) {
        this.outputType = outputType;
        this.environment = environment;
        this.selectionSetContainer = selectionSetContainer;
        this.graphQLContext = graphQLContext;
    }

    public GraphQLOutputType getOutputType() {
        return this.outputType;
    }

    public GraphQLCompositeType getUnwrappedOutputType() {
        return (GraphQLCompositeType)((Object)GraphQLTypeUtil.unwrapAll(this.outputType));
    }

    public QueryVisitorFieldEnvironment getEnvironment() {
        return this.environment;
    }

    public SelectionSetContainer<?> getSelectionSetContainer() {
        return this.selectionSetContainer;
    }

    public GraphQLContext getGraphQLContext() {
        return this.graphQLContext;
    }
}

