/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.util.DomainSocketAddress;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServerPort;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.LongAdder;

final class ServerPortMetric {
    static final AttributeKey<ServerPortMetric> SERVER_PORT_METRIC = AttributeKey.valueOf(ServerPortMetric.class, "SERVER_PORT_METRIC");
    private final LongAdder pendingHttp1Requests = new LongAdder();
    private final LongAdder pendingHttp2Requests = new LongAdder();
    private final LongAdder activeHttp1WebSocketRequests = new LongAdder();
    private final LongAdder activeHttp1Requests = new LongAdder();
    private final LongAdder activeHttp2Requests = new LongAdder();
    private final LongAdder activeConnections = new LongAdder();

    ServerPortMetric() {
    }

    void increasePendingHttp1Requests() {
        this.pendingHttp1Requests.increment();
    }

    void decreasePendingHttp1Requests() {
        this.pendingHttp1Requests.decrement();
    }

    void increasePendingHttp2Requests() {
        this.pendingHttp2Requests.increment();
    }

    void decreasePendingHttp2Requests() {
        this.pendingHttp2Requests.decrement();
    }

    void increaseActiveHttp1WebSocketRequests() {
        this.activeHttp1WebSocketRequests.increment();
    }

    void decreaseActiveHttp1WebSocketRequests() {
        this.activeHttp1WebSocketRequests.decrement();
    }

    void increaseActiveHttp1Requests() {
        this.activeHttp1Requests.increment();
    }

    void decreaseActiveHttp1Requests() {
        this.activeHttp1Requests.decrement();
    }

    void increaseActiveHttp2Requests() {
        this.activeHttp2Requests.increment();
    }

    void decreaseActiveHttp2Requests() {
        this.activeHttp2Requests.decrement();
    }

    void increaseActiveConnections() {
        this.activeConnections.increment();
    }

    void decreaseActiveConnections() {
        this.activeConnections.decrement();
    }

    long pendingHttp1Requests() {
        return this.pendingHttp1Requests.sum();
    }

    long pendingHttp2Requests() {
        return this.pendingHttp2Requests.sum();
    }

    long activeHttp1WebSocketRequests() {
        return this.activeHttp1WebSocketRequests.sum();
    }

    long activeHttp1Requests() {
        return this.activeHttp1Requests.sum();
    }

    long activeHttp2Requests() {
        return this.activeHttp2Requests.sum();
    }

    long activeConnections() {
        return this.activeConnections.sum();
    }

    void bindTo(MeterRegistry meterRegistry, ServerPort actualPort) {
        Tag portTag;
        InetSocketAddress address = actualPort.localAddress();
        if (address instanceof DomainSocketAddress) {
            String path = ((DomainSocketAddress)address).path();
            portTag = Tag.of("port", path);
        } else {
            portTag = Tag.of("port", String.valueOf(address.getPort()));
        }
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(portTag, Tag.of("protocol", "http1"), Tag.of("state", "pending")), this, ServerPortMetric::pendingHttp1Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(portTag, Tag.of("protocol", "http2"), Tag.of("state", "pending")), this, ServerPortMetric::pendingHttp2Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(portTag, Tag.of("protocol", "http1"), Tag.of("state", "active")), this, ServerPortMetric::activeHttp1Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(portTag, Tag.of("protocol", "http2"), Tag.of("state", "active")), this, ServerPortMetric::activeHttp2Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(portTag, Tag.of("protocol", "http1"), Tag.of("state", "active_websocket")), this, ServerPortMetric::activeHttp1WebSocketRequests);
        meterRegistry.gauge("armeria.server.connections", ImmutableList.of(portTag), this, ServerPortMetric::activeConnections);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("pendingHttp1Requests", this.pendingHttp1Requests).add("pendingHttp2Requests", this.pendingHttp2Requests).add("activeHttp1WebSocketRequests", this.activeHttp1WebSocketRequests).add("activeHttp1Requests", this.activeHttp1Requests).add("activeHttp2Requests", this.activeHttp2Requests).add("activeConnections", this.activeConnections).toString();
    }
}

