/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.process;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.process.ProcessRelationClientSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.process.ProcessRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ProcessRelation;

public class ProcessRelationDispatcher
implements SourceDispatcher<ProcessRelation> {
    @Override
    public void dispatch(ProcessRelation source) {
        switch (source.getDetectPoint()) {
            case SERVER: {
                this.processRelationServerSide(source);
                break;
            }
            case CLIENT: {
                this.processRelationClientSide(source);
            }
        }
    }

    private void processRelationServerSide(ProcessRelation relation) {
        ProcessRelationServerSideMetrics metrics = new ProcessRelationServerSideMetrics();
        metrics.setTimeBucket(TimeBucket.getMinuteTimeBucket(System.currentTimeMillis()));
        metrics.setServiceInstanceId(relation.getInstanceId());
        metrics.setSourceProcessId(relation.getSourceProcessId());
        metrics.setDestProcessId(relation.getDestProcessId());
        metrics.setEntityId(relation.getEntityId());
        metrics.setComponentId(relation.getComponentId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }

    private void processRelationClientSide(ProcessRelation entity) {
        ProcessRelationClientSideMetrics metrics = new ProcessRelationClientSideMetrics();
        metrics.setTimeBucket(TimeBucket.getMinuteTimeBucket(System.currentTimeMillis()));
        metrics.setServiceInstanceId(entity.getInstanceId());
        metrics.setSourceProcessId(entity.getSourceProcessId());
        metrics.setDestProcessId(entity.getDestProcessId());
        metrics.setEntityId(entity.getEntityId());
        metrics.setComponentId(entity.getComponentId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }
}

