/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.cache;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.manual.cache.TopNCacheReadCommand;
import org.apache.skywalking.oap.server.core.analysis.manual.cache.TopNCacheWriteCommand;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.source.CacheSlowAccess;
import org.apache.skywalking.oap.server.core.source.VirtualCacheOperation;

public class CacheSlowAccessDispatcher
implements SourceDispatcher<CacheSlowAccess> {
    @Override
    public void dispatch(CacheSlowAccess source) {
        if (source.getOperation() == VirtualCacheOperation.Read) {
            TopNCacheReadCommand readCommand = new TopNCacheReadCommand();
            readCommand.setId(source.getId());
            readCommand.setCommand(source.getCommand() + " " + source.getKey());
            readCommand.setLatency(source.getLatency());
            readCommand.setTraceId(source.getTraceId());
            readCommand.setEntityId(source.getCacheServiceId());
            readCommand.setTimeBucket(source.getTimeBucket());
            readCommand.setTimestamp(source.getTimestamp());
            TopNStreamProcessor.getInstance().in(readCommand);
        } else if (source.getOperation() == VirtualCacheOperation.Write) {
            TopNCacheWriteCommand writeCommand = new TopNCacheWriteCommand();
            writeCommand.setId(source.getId());
            writeCommand.setCommand(source.getCommand() + " " + source.getKey());
            writeCommand.setLatency(source.getLatency());
            writeCommand.setTraceId(source.getTraceId());
            writeCommand.setEntityId(source.getCacheServiceId());
            writeCommand.setTimeBucket(source.getTimeBucket());
            writeCommand.setTimestamp(source.getTimestamp());
            TopNStreamProcessor.getInstance().in(writeCommand);
        }
    }
}

