/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.operation.AggregationOp;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.query.mqe.Metadata;

public class SortValuesOp {
    public static ExpressionResult doSortValuesOp(ExpressionResult expResult, int limit, int order, int aggregationType) throws IllegalExpressionException {
        if (!expResult.isLabeledResult()) {
            return expResult;
        }
        Map<Metadata, MQEValues> resultMap = expResult.getResults().stream().collect(Collectors.toMap(MQEValues::getMetric, v -> {
            MQEValues newValues = new MQEValues();
            newValues.setMetric(v.getMetric());
            newValues.setValues(v.getValues());
            return newValues;
        }));
        ExpressionResult aggResult = AggregationOp.doAggregationOp(expResult, aggregationType);
        List<MQEValues> sorted = aggResult.getResults().stream().sorted(SortValuesOp.getComparator(order)).collect(Collectors.toList());
        if (limit < sorted.size()) {
            sorted = sorted.subList(0, limit);
        }
        ArrayList results = new ArrayList();
        sorted.forEach(v -> {
            MQEValues mqeValues = (MQEValues)resultMap.get(v.getMetric());
            if (mqeValues != null) {
                results.add(mqeValues);
            }
        });
        expResult.setResults(results);
        expResult.setType(ExpressionResultType.TIME_SERIES_VALUES);
        return expResult;
    }

    private static Comparator<MQEValues> getComparator(int order) {
        Comparator<MQEValues> comparator = Comparator.comparingDouble(mqeValues -> mqeValues.getValues().isEmpty() ? Double.NaN : ((MQEValue)mqeValues.getValues().get(0)).getDoubleValue());
        return order == 42 ? comparator : comparator.reversed();
    }
}

