/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SplitHttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.internal.common.AbstractSplitHttpMessage;
import com.linecorp.armeria.internal.common.HeadersFuture;
import com.linecorp.armeria.internal.common.SplitHttpMessageSubscriber;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;

public class DefaultSplitHttpResponse
extends AbstractSplitHttpMessage
implements SplitHttpResponse {
    private static final ResponseHeaders HEADERS_WITH_UNKNOWN_STATUS = ResponseHeaders.of(HttpStatus.UNKNOWN);
    private final SplitHttpResponseBodySubscriber bodySubscriber;

    public DefaultSplitHttpResponse(HttpResponse response, EventExecutor upstreamExecutor) {
        this(response, upstreamExecutor, (ResponseHeaders headers) -> !headers.status().isInformational());
    }

    public DefaultSplitHttpResponse(HttpResponse response, EventExecutor upstreamExecutor, Predicate<ResponseHeaders> finalResponseHeadersPredicate) {
        this(response, upstreamExecutor, new SplitHttpResponseBodySubscriber(response, upstreamExecutor, finalResponseHeadersPredicate));
    }

    private DefaultSplitHttpResponse(HttpResponse response, EventExecutor upstreamExecutor, SplitHttpResponseBodySubscriber bodySubscriber) {
        super(response, upstreamExecutor, bodySubscriber);
        this.bodySubscriber = bodySubscriber;
    }

    @Override
    public final CompletableFuture<ResponseHeaders> headers() {
        return this.bodySubscriber.headersFuture();
    }

    private static final class SplitHttpResponseBodySubscriber
    extends SplitHttpMessageSubscriber {
        private final HeadersFuture<ResponseHeaders> headersFuture = new HeadersFuture();
        private final Predicate<ResponseHeaders> finalResponseHeadersPredicate;

        SplitHttpResponseBodySubscriber(HttpResponse response, EventExecutor upstreamExecutor, Predicate<ResponseHeaders> finalResponseHeadersPredicate) {
            super(1, response, upstreamExecutor);
            this.finalResponseHeadersPredicate = finalResponseHeadersPredicate;
        }

        CompletableFuture<ResponseHeaders> headersFuture() {
            return this.headersFuture;
        }

        @Override
        public void onNext(HttpObject httpObject) {
            if (httpObject instanceof ResponseHeaders) {
                ResponseHeaders headers = (ResponseHeaders)httpObject;
                if (this.finalResponseHeadersPredicate.test(headers)) {
                    this.headersFuture.doComplete(headers);
                } else {
                    Subscription upstream = this.upstream();
                    assert (upstream != null);
                    upstream.request(1L);
                }
                return;
            }
            super.onNext(httpObject);
        }

        @Override
        protected void doOnCompletion(@Nullable Throwable cause) {
            if (!this.headersFuture.isDone()) {
                if (cause != null && !(cause instanceof CancelledSubscriptionException) && !(cause instanceof AbortedStreamException)) {
                    this.headersFuture.doCompleteExceptionally(cause);
                } else {
                    this.headersFuture.doComplete(HEADERS_WITH_UNKNOWN_STATUS);
                }
            }
        }
    }
}

