/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.JsonHeadersSanitizer;
import com.linecorp.armeria.common.logging.JsonHeadersSanitizerBuilder;
import com.linecorp.armeria.common.logging.TextHeadersSanitizer;
import com.linecorp.armeria.common.logging.TextHeadersSanitizerBuilder;
import java.util.function.BiFunction;

@FunctionalInterface
public interface HeadersSanitizer<T>
extends BiFunction<RequestContext, HttpHeaders, T> {
    public static HeadersSanitizer<String> ofText() {
        return TextHeadersSanitizer.INSTANCE;
    }

    public static TextHeadersSanitizerBuilder builderForText() {
        return new TextHeadersSanitizerBuilder();
    }

    public static HeadersSanitizer<JsonNode> ofJson() {
        return JsonHeadersSanitizer.INSTANCE;
    }

    public static JsonHeadersSanitizerBuilder builderForJson() {
        return new JsonHeadersSanitizerBuilder();
    }

    @Nullable
    public T sanitize(RequestContext var1, HttpHeaders var2);

    @Override
    @Nullable
    default public T apply(RequestContext requestContext, HttpHeaders entries) {
        return this.sanitize(requestContext, entries);
    }
}

