/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareConsumer;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.SafeCloseable;
import java.util.Objects;
import java.util.function.Consumer;

final class DefaultContextAwareConsumer<T>
implements ContextAwareConsumer<T> {
    private final RequestContext context;
    private final Consumer<T> action;

    DefaultContextAwareConsumer(RequestContext context, Consumer<T> action) {
        this.context = Objects.requireNonNull(context, "context");
        this.action = Objects.requireNonNull(action, "action");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Consumer<T> withoutContext() {
        return this.action;
    }

    @Override
    public void accept(T t) {
        try (SafeCloseable ignored = this.context.push();){
            this.action.accept(t);
        }
    }
}

