/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.telemetry.prometheus.httpserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.server.ssl.AbstractSslContext;
import org.apache.skywalking.oap.server.library.server.ssl.HTTPDynamicSslContext;
import org.apache.skywalking.oap.server.telemetry.prometheus.PrometheusConfig;
import org.apache.skywalking.oap.server.telemetry.prometheus.httpserver.HttpServerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpServer.class);
    private final PrometheusConfig config;

    public void start() throws InterruptedException {
        HTTPDynamicSslContext sslCtx = this.config.isSslEnabled() ? HTTPDynamicSslContext.forServer((String)this.config.getSslKeyPath(), (String)this.config.getSslCertChainPath()) : null;
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).build();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, tf);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, tf);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new HttpServerInitializer((SslContext)sslCtx));
        b.bind(this.config.getHost(), this.config.getPort()).sync();
        Optional.ofNullable(sslCtx).ifPresent(AbstractSslContext::start);
        log.info("Prometheus exporter endpoint:" + (this.config.isSslEnabled() ? "https" : "http") + "://" + this.config.getHost() + ":" + this.config.getPort() + "/");
    }

    @Generated
    public HttpServer(PrometheusConfig config) {
        this.config = config;
    }
}

