/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.Element;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBEventQueryDAO
extends AbstractBanyanDBDAO
implements IEventQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"uuid", (Object)"service", (Object)"service_instance", (Object)"endpoint", (Object)"event_name", (Object)"message", (Object[])new String[]{"type", "start_time", "end_time", "parameters", "layer", "timestamp"});

    public BanyanDBEventQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        Duration time = condition.getTime();
        boolean isColdStage = time != null && time.isColdStage();
        StreamQueryResponse resp = this.query(isColdStage, "event", TAGS, this.getTimestampRange(time), this.buildQuery(Collections.singletonList(condition)));
        Events events = new Events();
        if (resp.size() == 0) {
            return events;
        }
        for (Element e : resp.getElements()) {
            events.getEvents().add(this.buildEventView(e));
        }
        return events;
    }

    public Events queryEvents(List<EventQueryCondition> conditionList) throws Exception {
        Duration time = conditionList.get(0).getTime();
        boolean isColdStage = time != null && time.isColdStage();
        StreamQueryResponse resp = this.query(isColdStage, "event", TAGS, this.getTimestampRange(time), this.buildQuery(conditionList));
        Events events = new Events();
        if (resp.size() == 0) {
            return events;
        }
        for (Element e : resp.getElements()) {
            events.getEvents().add(this.buildEventView(e));
        }
        return events;
    }

    public AbstractBanyanDBDAO.QueryBuilder<StreamQuery> buildQuery(final List<EventQueryCondition> conditionList) {
        EventQueryCondition condition = conditionList.get(0);
        final Order queryOrder = Objects.isNull(condition.getOrder()) ? Order.DES : condition.getOrder();
        final PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
        return new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                ArrayList<AbstractCriteria> eventsQueryConditions = new ArrayList<AbstractCriteria>(conditionList.size());
                query.setLimit(page.getLimit());
                query.setOffset(page.getFrom());
                if (queryOrder == Order.ASC) {
                    query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.ASC));
                } else {
                    query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.DESC));
                }
                for (EventQueryCondition condition : conditionList) {
                    Source source;
                    ArrayList<Object> queryConditions = new ArrayList<Object>();
                    if (!Strings.isNullOrEmpty((String)condition.getUuid())) {
                        queryConditions.add(this.eq("uuid", condition.getUuid()));
                    }
                    if ((source = condition.getSource()) != null) {
                        if (!Strings.isNullOrEmpty((String)source.getService())) {
                            queryConditions.add(this.eq("service", source.getService()));
                        }
                        if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                            queryConditions.add(this.eq("service_instance", source.getServiceInstance()));
                        }
                        if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                            queryConditions.add(this.eq("endpoint", source.getEndpoint()));
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)condition.getName())) {
                        queryConditions.add(this.eq("event_name", condition.getName()));
                    }
                    if (condition.getType() != null) {
                        queryConditions.add(this.eq("type", condition.getType().name()));
                    }
                    if (!Strings.isNullOrEmpty((String)condition.getLayer())) {
                        queryConditions.add(this.eq("layer", Layer.valueOf((String)condition.getLayer()).value()));
                    }
                    eventsQueryConditions.add(this.and(queryConditions));
                }
                if (eventsQueryConditions.size() == 1) {
                    query.criteria((AbstractCriteria)eventsQueryConditions.get(0));
                } else if (eventsQueryConditions.size() > 1) {
                    query.criteria(this.or(eventsQueryConditions));
                }
            }
        };
    }

    protected Event buildEventView(Element e) {
        Event event = new Event();
        event.setUuid((String)e.getTagValue("uuid"));
        String service = this.getValueOrDefault(e, "service", "");
        String serviceInstance = this.getValueOrDefault(e, "service_instance", "");
        String endpoint = this.getValueOrDefault(e, "endpoint", "");
        event.setSource(new Source(service, serviceInstance, endpoint));
        event.setName((String)e.getTagValue("event_name"));
        event.setType(EventType.parse((String)((String)e.getTagValue("type"))));
        event.setMessage((String)e.getTagValue("message"));
        event.setParameters((String)e.getTagValue("parameters"));
        event.setStartTime(((Long)e.getTagValue("start_time")).longValue());
        event.setEndTime(((Long)e.getTagValue("end_time")).longValue());
        event.setTimestamp(((Long)e.getTagValue("timestamp")).longValue());
        event.setLayer(Layer.valueOf((int)((Number)e.getTagValue("layer")).intValue()).name());
        return event;
    }

    private <T> T getValueOrDefault(Element e, String tagName, T defaultValue) {
        Object v = e.getTagValue(tagName);
        return (T)(v == null ? defaultValue : v);
    }
}

