/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;

public class JDBCMetricsDAO
extends JDBCSQLExecutor
implements IMetricsDAO {
    private final JDBCClient jdbcClient;
    private final StorageBuilder<Metrics> storageBuilder;

    public List<Metrics> multiGet(Model model, List<Metrics> metrics) throws Exception {
        List<String> ids = metrics.stream().map(m -> TableHelper.generateId(model, m.id().build())).collect(Collectors.toList());
        List<StorageData> storageDataList = this.getByIDs(this.jdbcClient, model.getName(), ids, this.storageBuilder);
        ArrayList<Metrics> result = new ArrayList<Metrics>(storageDataList.size());
        for (StorageData storageData : storageDataList) {
            result.add((Metrics)storageData);
        }
        return result;
    }

    public SQLExecutor prepareBatchInsert(Model model, Metrics metrics, SessionCacheCallback callback) throws IOException {
        return this.getInsertExecutor(model, metrics, metrics.getTimeBucket(), this.storageBuilder, (Convert2Storage<Map<String, Object>>)new HashMapConverter.ToStorage(), callback);
    }

    public SQLExecutor prepareBatchUpdate(Model model, Metrics metrics, SessionCacheCallback callback) {
        return this.getUpdateExecutor(model, metrics, metrics.getTimeBucket(), this.storageBuilder, callback);
    }

    @Generated
    public JDBCMetricsDAO(JDBCClient jdbcClient, StorageBuilder<Metrics> storageBuilder) {
        this.jdbcClient = jdbcClient;
        this.storageBuilder = storageBuilder;
    }
}

