/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.datetime;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;

@Internal
public final class TimeScalar {
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_OFFSET_TIME;
    public static final GraphQLScalarType INSTANCE;

    private TimeScalar() {
    }

    static {
        Coercing<OffsetTime, String> coercing = new Coercing<OffsetTime, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                TemporalAccessor temporalAccessor;
                if (input instanceof TemporalAccessor) {
                    temporalAccessor = (TemporalAccessor)input;
                } else if (input instanceof String) {
                    temporalAccessor = this.parseOffsetTime(input.toString(), CoercingSerializeException::new);
                } else {
                    throw new CoercingSerializeException("Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '" + Kit.typeName(input) + "'.");
                }
                try {
                    return dateFormatter.format(temporalAccessor);
                }
                catch (DateTimeException e) {
                    throw new CoercingSerializeException("Unable to turn TemporalAccessor into full time because of : '" + e.getMessage() + "'.");
                }
            }

            public OffsetTime parseValue(Object input) throws CoercingParseValueException {
                TemporalAccessor temporalAccessor;
                if (input instanceof TemporalAccessor) {
                    temporalAccessor = (TemporalAccessor)input;
                } else if (input instanceof String) {
                    temporalAccessor = this.parseOffsetTime(input.toString(), CoercingParseValueException::new);
                } else {
                    throw new CoercingParseValueException("Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '" + Kit.typeName(input) + "'.");
                }
                try {
                    return OffsetTime.from(temporalAccessor);
                }
                catch (DateTimeException e) {
                    throw new CoercingParseValueException("Unable to turn TemporalAccessor into full time because of : '" + e.getMessage() + "'.");
                }
            }

            public OffsetTime parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseOffsetTime(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }

            private OffsetTime parseOffsetTime(String s, Function<String, RuntimeException> exceptionMaker) {
                try {
                    TemporalAccessor temporalAccessor = dateFormatter.parse(s);
                    return OffsetTime.from(temporalAccessor);
                }
                catch (DateTimeParseException e) {
                    throw exceptionMaker.apply("Invalid RFC3339 full time value : '" + s + "'. because of : '" + e.getMessage() + "'");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Time").description("An RFC-3339 compliant Full Time Scalar").coercing((Coercing)coercing).build();
    }
}

