/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.Buffer;
import java.util.List;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.internal.shared.AssertionMessages;
import org.apache.sis.image.internal.shared.RasterFactory;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gdal.ColorInterpretation;
import org.apache.sis.storage.gdal.DataType;
import org.apache.sis.storage.gdal.ErrorHandler;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.opengis.referencing.operation.MathTransform1D;

final class Band {
    private final MemorySegment handle;

    Band(MemorySegment handle) {
        this.handle = handle;
    }

    static boolean isTrue(MemorySegment flag) {
        return flag.get(ValueLayout.JAVA_INT, 0L) != 0;
    }

    final double getValue(MethodHandle getter, MemorySegment flag) {
        double value;
        try {
            value = getter.invokeExact(this.handle, flag);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return value;
    }

    final SampleDimension createSampleDimension(GDALStore parent, GDAL gdal, MemorySegment flag) throws DataStoreException {
        MemorySegment names;
        MemorySegment uom;
        double offset;
        boolean convert;
        double scale;
        boolean hasNoData;
        double nodata;
        double maximum;
        boolean hasRange;
        double minimum;
        int band;
        try {
            band = gdal.getBandNumber.invokeExact(this.handle);
            minimum = gdal.getRasterMinimum.invokeExact(this.handle, flag);
            hasRange = Band.isTrue(flag);
            maximum = gdal.getRasterMaximum.invokeExact(this.handle, flag);
            hasRange &= Band.isTrue(flag);
            nodata = gdal.getRasterNoDataValue.invokeExact(this.handle, flag);
            hasNoData = Band.isTrue(flag);
            scale = gdal.getRasterScale.invokeExact(this.handle, flag);
            convert = Band.isTrue(flag);
            offset = gdal.getRasterOffset.invokeExact(this.handle, flag);
            convert &= Band.isTrue(flag);
            uom = gdal.getRasterUnitType.invokeExact(this.handle);
            names = gdal.getRasterCategoryNames.invokeExact(this.handle);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        List<String> categories = GDAL.fromNullTerminatedStrings(names);
        String symbol = GDAL.toString(uom);
        Unit units = null;
        if (symbol != null && !symbol.isBlank()) {
            try {
                convert = true;
                units = Units.valueOf((String)symbol);
            }
            catch (MeasurementParseException e) {
                parent.warning("getSampleDimensions", e.getMessage(), e);
            }
        }
        SampleDimension.Builder builder = new SampleDimension.Builder();
        if (hasNoData) {
            builder.setBackground((Number)nodata);
        }
        if (hasRange | convert) {
            NumberRange range = NumberRange.create((double)minimum, (boolean)true, (double)maximum, (boolean)true);
            if (convert) {
                String name = null;
                if (categories != null && minimum <= maximum) {
                    int index = Math.max((int)Math.ceil(minimum), 0);
                    int limit = Math.min((int)Math.floor(maximum), categories.size() - 1);
                    while (index <= limit) {
                        String item = categories.set(index, "");
                        if (name != null || item.isBlank()) continue;
                        name = item;
                    }
                }
                builder.addQuantitative(name, range, (MathTransform1D)MathTransforms.linear((double)scale, (double)offset), units);
            } else if (categories == null) {
                builder.addQualitative(null, range);
            }
        }
        if (categories != null) {
            int n = categories.size();
            for (int i = 0; i < n; ++i) {
                String item = categories.get(i);
                if (item.isEmpty()) continue;
                builder.addQualitative((CharSequence)item, i);
            }
        }
        if (band > 0) {
            builder.setName(band);
        }
        return builder.build();
    }

    final ColorInterpretation getColorInterpretation(GDAL gdal) {
        int n;
        try {
            n = gdal.getColorInterpretation.invokeExact(this.handle);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return ColorInterpretation.valueOf(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int[] getARGB(GDAL gdal) {
        try (Arena arena = Arena.ofConfined();){
            ValueLayout.OfShort layout = ValueLayout.JAVA_SHORT;
            MemorySegment colorEntry = arena.allocate(layout, 4L);
            MemorySegment colors = gdal.getRasterColorTable.invokeExact(this.handle);
            if (GDAL.isNull(colors)) return null;
            int count = gdal.getColorEntryCount.invokeExact(colors);
            int[] ARGB = new int[count];
            for (int i = 0; i < count; ++i) {
                int err = gdal.getColorEntryAsRGB.invokeExact(colors, i, colorEntry);
                if (!ErrorHandler.checkCPLErr(err)) {
                    int[] nArray = null;
                    return nArray;
                }
                short c1 = colorEntry.getAtIndex(layout, 0L);
                short c2 = colorEntry.getAtIndex(layout, 1L);
                short c3 = colorEntry.getAtIndex(layout, 2L);
                short c4 = colorEntry.getAtIndex(layout, 3L);
                ARGB[i] = Short.toUnsignedInt(c4) << 24 | Short.toUnsignedInt(c1) << 16 | Short.toUnsignedInt(c2) << 8 | Short.toUnsignedInt(c3);
            }
            int[] nArray = ARGB;
            return nArray;
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
    }

    static boolean transfer(GDAL gdal, int readWriteFlags, Band[] selectedBands, DataType resourceType, Rectangle resourceBounds, Raster raster, Rectangle rasterBounds, MemorySegment transferBuffer) throws DataStoreException {
        if (readWriteFlags == 0 && !(raster instanceof WritableRaster)) {
            throw new ClassCastException();
        }
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataType rasterType = resourceType.forDataBufferType(dataBuffer.getDataType());
        int dataSize = DataBuffer.getDataTypeSize(dataBuffer.getDataType()) / 8;
        ComponentSampleModel sampleModel = (ComponentSampleModel)raster.getSampleModel();
        int pixelStride = Math.multiplyExact(dataSize, sampleModel.getPixelStride());
        int scanlineStride = Math.multiplyExact(dataSize, sampleModel.getScanlineStride());
        int[] bankIndices = sampleModel.getBankIndices();
        if (!raster.getBounds().contains(rasterBounds)) {
            throw new AssertionError((Object)AssertionMessages.notContained((Rectangle)raster.getBounds(), (Rectangle)rasterBounds));
        }
        if (transferBuffer.byteSize() < Math.multiplyFull(rasterBounds.width, rasterBounds.height) * (long)dataSize) {
            throw new AssertionError(rasterBounds);
        }
        for (int b = 0; b < selectedBands.length; ++b) {
            int err;
            int x = rasterBounds.x - raster.getSampleModelTranslateX();
            int y = rasterBounds.y - raster.getSampleModelTranslateY();
            int offset = sampleModel.getOffset(x, y, b);
            Buffer buffer = RasterFactory.wrapAsBuffer((DataBuffer)dataBuffer, (int)bankIndices[b]).position(offset);
            try {
                err = gdal.rasterIO.invokeExact(selectedBands[b].handle, readWriteFlags, resourceBounds.x, resourceBounds.y, resourceBounds.width, resourceBounds.height, transferBuffer, rasterBounds.width, rasterBounds.height, rasterType.ordinal(), pixelStride, scanlineStride);
            }
            catch (Throwable e) {
                throw GDAL.propagate(e);
            }
            if (!ErrorHandler.checkCPLErr(err)) {
                return false;
            }
            MemorySegment.ofBuffer(buffer).copyFrom(transferBuffer);
        }
        return true;
    }

    final boolean adviseRead(GDAL gdal, Rectangle resourceBounds, Rectangle imageBounds, DataType imageType) throws DataStoreException {
        int err;
        try {
            err = gdal.adviseRead.invokeExact(this.handle, resourceBounds.x, resourceBounds.y, resourceBounds.width, resourceBounds.height, imageBounds.width, imageBounds.height, imageType.ordinal(), MemorySegment.NULL);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return ErrorHandler.checkCPLErr(err);
    }
}

