/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.geometry.DirectPosition1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedTransform1D
extends ConcatenatedTransform
implements MathTransform1D {
    private static final long serialVersionUID = 8150427971141078395L;

    ConcatenatedTransform1D(MathTransform transform1, MathTransform transform2) {
        super(transform1, transform2);
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 1 && this.getTargetDimensions() == 1;
    }

    public double transform(double value) throws TransformException {
        double[] values = new double[]{value};
        double[] buffer = new double[]{this.transform1.getTargetDimensions()};
        this.transform1.transform(values, 0, buffer, 0, 1);
        this.transform2.transform(buffer, 0, values, 0, 1);
        return values[0];
    }

    public double derivative(double value) throws TransformException {
        DirectPosition1D p = new DirectPosition1D(value);
        Matrix m = super.derivative(p);
        assert (m.getNumRow() == 1 && m.getNumCol() == 1);
        return m.getElement(0, 0);
    }

    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }
}

