/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.StandardGeometries;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.logging.Logging;

public final class GeometryFactories {
    static final Geometries<?> DEFAULT = GeometryFactories.link(GeometryFactories.link(GeometryFactories.link(null, "j2d"), "esri"), "jts");

    private GeometryFactories() {
    }

    private static Geometries<?> link(Geometries<?> previous, String name) {
        Geometries factory;
        String classname = GeometryFactories.class.getPackageName() + "." + name + ".Factory";
        try {
            factory = (Geometries)Class.forName(classname).getField("INSTANCE").get(null);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            LogRecord record = Resources.forLocale(null).createLogRecord(Level.CONFIG, (short)56, name, e.toString());
            Logging.completeAndLog((Logger)Geometries.LOGGER, Geometries.class, (String)"register", (LogRecord)record);
            return previous;
        }
        factory.fallback = previous;
        return factory;
    }

    public static void setStandard(Geometries<?> standard) {
        Geometries<?> factory = DEFAULT;
        do {
            Geometries<?> last = factory;
        } while ((factory = factory.fallback) != null && factory.library != GeometryLibrary.GEOAPI);
        last.fallback = standard;
    }

    static {
        GeometryFactories.setStandard(new StandardGeometries(DEFAULT));
    }
}

