/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.SortedMap;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.EvaluatorWrapper;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.internal.shared.ReshapedImage;
import org.apache.sis.util.CorruptedObjectException;
import org.opengis.referencing.operation.TransformException;

final class ClippedGridCoverage
extends DerivedGridCoverage {
    private final Map<Integer, Long> defaultSlice;

    private ClippedGridCoverage(GridCoverage source, GridGeometry domain) {
        super(source, domain);
        SortedMap<Integer, Long> c = domain.getExtent().getSliceCoordinates();
        this.defaultSlice = c.equals(source.getGridGeometry().getExtent().getSliceCoordinates()) ? null : Map.copyOf(c);
    }

    static GridCoverage create(GridCoverage source, GridExtent clip, boolean allowSourceReplacement) {
        GridGeometry gridGeometry = source.getGridGeometry();
        GridExtent extent = gridGeometry.getExtent();
        if (extent == (extent = extent.intersect(clip))) {
            return source;
        }
        if (allowSourceReplacement) {
            while (source instanceof ClippedGridCoverage) {
                source = ((ClippedGridCoverage)source).source;
                if (!extent.equals(source.gridGeometry.extent)) continue;
                return source;
            }
        }
        try {
            gridGeometry = new GridGeometry(gridGeometry, extent, null);
        }
        catch (TransformException e) {
            throw new CorruptedObjectException((Exception)((Object)e));
        }
        return new ClippedGridCoverage(source, gridGeometry);
    }

    @Override
    protected final GridCoverage createConvertedValues(boolean converted) {
        GridCoverage c = this.source.forConvertedValues(converted);
        return c == this.source ? this : new ClippedGridCoverage(c, this.gridGeometry);
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        GridExtent clipped = sliceExtent == null ? (sliceExtent = this.gridGeometry.extent) : sliceExtent.intersect(this.gridGeometry.extent);
        RenderedImage image = this.source.render(clipped);
        if (clipped != sliceExtent) {
            long any = 0L;
            long[] translation = new long[clipped.getDimension()];
            for (int i = 0; i < translation.length; ++i) {
                translation[i] = Math.subtractExact(clipped.getLow(i), sliceExtent.getLow(i));
                any |= translation[i];
            }
            if (any != 0L) {
                Object property = image.getProperty("org.apache.sis.XYDimensions");
                int[] gridDimensions = property instanceof int[] ? (int[])property : clipped.getSubspaceDimensions(2);
                ReshapedImage t = new ReshapedImage(image, translation[gridDimensions[0]], translation[gridDimensions[1]]);
                return t.isIdentity() ? t.source : t;
            }
        }
        return image;
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        GridCoverage.Evaluator evaluator = this.source.evaluator();
        if (this.defaultSlice != null) {
            evaluator = new SliceEvaluator(evaluator);
        }
        return evaluator;
    }

    private final class SliceEvaluator
    extends EvaluatorWrapper {
        SliceEvaluator(GridCoverage.Evaluator source) {
            super(source);
            super.setDefaultSlice(ClippedGridCoverage.this.defaultSlice);
        }

        @Override
        public GridCoverage getCoverage() {
            return ClippedGridCoverage.this;
        }

        @Override
        public void setDefaultSlice(Map<Integer, Long> slice) {
            super.setDefaultSlice(slice != null ? slice : ClippedGridCoverage.this.defaultSlice);
        }
    }
}

