/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Locale;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.gui.dataset.PathAction;
import org.apache.sis.gui.dataset.ResourceItem;
import org.apache.sis.gui.dataset.ResourceTree;
import org.apache.sis.gui.dataset.TreeViewType;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.URIDataStoreProvider;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Vocabulary;

final class ResourceCell
extends TreeCell<Resource> {
    private TreeViewType viewType;
    private static final int COPY_PATH = 0;
    private static final int OPEN_FOLDER = 1;
    private static final int AGGREGATED = 2;
    private static final int CLOSE = 3;

    ResourceCell() {
    }

    protected void updateItem(Resource resource, boolean empty) {
        TreeItem t;
        super.updateItem((Object)resource, empty);
        Color color = Styles.NORMAL_TEXT;
        String text = null;
        Button more = null;
        ContextMenu menu = null;
        if (!empty && (t = this.getTreeItem()) instanceof ResourceItem) {
            ResourceTree tree = (ResourceTree)this.getTreeView();
            ResourceItem item = (ResourceItem)t;
            text = item.label;
            if (item.isLoading) {
                color = Styles.LOADING_TEXT;
                if (text == null) {
                    text = item.label = tree.localized().getString((short)24);
                    if (resource != null) {
                        ResourceItem resourceItem = item;
                        Objects.requireNonNull(resourceItem);
                        tree.fetchLabel(new ResourceItem.Completer(resourceItem, resource));
                    }
                }
            } else {
                Throwable error = item.error;
                if (error != null) {
                    color = Styles.ERROR_TEXT;
                    if (text == null) {
                        if (resource != null) {
                            text = Vocabulary.forLocale((Locale)tree.locale).getString((short)208);
                        } else {
                            text = Strings.trimOrNull((String)Exceptions.getLocalizedMessage((Throwable)error, (Locale)tree.locale));
                            if (text == null) {
                                text = Classes.getShortClassName((Object)error);
                            }
                        }
                        item.label = text;
                    }
                    if ((more = (Button)this.getGraphic()) == null) {
                        more = new Button("\u2139\ufe0f");
                    }
                    more.setOnAction(e -> {
                        Resources localized = tree.localized();
                        ExceptionReporter.show((Node)tree, localized.getString((short)17), localized.getString((short)7), error);
                    });
                }
            }
            if (tree.findOrRemove(resource, false) != null) {
                Object path;
                try {
                    path = URIDataStoreProvider.location((Resource)resource);
                }
                catch (DataStoreException e2) {
                    path = null;
                    ResourceTree.unexpectedException("updateItem", (Exception)((Object)e2));
                }
                boolean aggregatable = item.isViewSelectable(resource, TreeViewType.AGGREGATION);
                menu = this.getContextMenu();
                if (menu == null) {
                    menu = new ContextMenu();
                    Resources localized = tree.localized();
                    Object[] items = new MenuItem[]{localized.menu((short)51, new PathAction(this, false)), localized.menu((short)66, new PathAction(this, true)), localized.menu((short)75, false, (ChangeListener<Boolean>)((ChangeListener)(p, o, n) -> this.setView(n != false ? TreeViewType.AGGREGATION : TreeViewType.SOURCE))), localized.menu((short)10, (EventHandler<ActionEvent>)((EventHandler)e -> ((ResourceTree)this.getTreeView()).removeAndClose((Resource)this.getItem())))};
                    menu.getItems().setAll(items);
                }
                ObservableList items = menu.getItems();
                ((MenuItem)items.get(0)).setDisable(!IOUtilities.isKindOfPath((Object)path));
                ((MenuItem)items.get(1)).setDisable(PathAction.isBrowseDisabled(path));
                CheckMenuItem aggregated = (CheckMenuItem)items.get(2);
                aggregated.setDisable(!aggregatable);
                aggregated.setSelected(aggregatable && item.isView(TreeViewType.AGGREGATION));
            }
        }
        this.setText(text);
        this.setTextFill((Paint)(this.isSelected() ? Styles.SELECTED_TEXT : color));
        this.setGraphic((Node)more);
        this.setContextMenu(menu);
    }

    private void setView(TreeViewType type) {
        this.viewType = type;
        ((ResourceItem)this.getTreeItem()).setView(this, type, ((ResourceTree)this.getTreeView()).locale);
    }

    final boolean isActiveView(TreeViewType type) {
        return this.viewType == type;
    }
}

