/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.filter.Filter;
import org.apache.sis.style.se1.Description;
import org.apache.sis.style.se1.Rule;
import org.apache.sis.style.se1.SemanticType;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;
import org.opengis.util.GenericName;

@XmlType(propOrder={"name", "description", "featureTypeName", "rules"})
public abstract class AbstractStyle<R>
extends StyleElement<R> {
    public static final String VERSION = "1.1.0";
    @XmlAttribute
    protected String version;
    @XmlElement(name="Name")
    protected String name;
    @XmlElement(name="Description")
    protected Description<R> description;
    protected Filter<? super R> featureInstanceIDs;
    @XmlElement(name="FeatureTypeName")
    protected GenericName featureTypeName;
    private EnumSet<SemanticType> semanticTypeIdentifiers;
    @XmlElement(name="Rule")
    private List<Rule<R>> rules;

    private void beforeUnmarshal(Unmarshaller caller, Object parent) {
        this.version = "unspecified";
    }

    public AbstractStyle(StyleFactory<R> factory) {
        super(factory);
        this.version = VERSION;
        this.semanticTypeIdentifiers = EnumSet.noneOf(SemanticType.class);
        this.rules = new ArrayList<Rule<R>>();
    }

    public AbstractStyle(AbstractStyle<R> source) {
        super(source);
        this.version = source.version;
        this.name = source.name;
        this.description = source.description;
        this.featureInstanceIDs = source.featureInstanceIDs;
        this.featureTypeName = source.featureTypeName;
        this.semanticTypeIdentifiers = source.semanticTypeIdentifiers.clone();
        this.rules = new ArrayList<Rule<R>>(source.rules);
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(String value) {
        this.name = value;
    }

    public Optional<Description<R>> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(Description<R> value) {
        this.description = value;
    }

    public Optional<Filter<? super R>> getFeatureInstanceIDs() {
        return Optional.ofNullable(this.featureInstanceIDs);
    }

    public void setFeatureInstanceIDs(Filter<? super R> value) {
        this.featureInstanceIDs = value;
    }

    public Optional<GenericName> getFeatureTypeName() {
        return Optional.ofNullable(this.featureTypeName);
    }

    public void setFeatureTypeName(GenericName value) {
        this.featureTypeName = value;
    }

    public Set<SemanticType> semanticTypeIdentifiers() {
        return this.semanticTypeIdentifiers;
    }

    public List<Rule<R>> rules() {
        return this.rules;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.name, this.description, this.featureInstanceIDs, this.featureTypeName, this.semanticTypeIdentifiers, this.rules};
    }

    @Override
    public AbstractStyle<R> clone() {
        AbstractStyle clone = (AbstractStyle)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.description != null) {
            this.description = this.description.clone();
        }
        this.semanticTypeIdentifiers = this.semanticTypeIdentifiers.clone();
        this.rules = new ArrayList<Rule<R>>(this.rules);
        this.rules.replaceAll(Rule::clone);
    }
}

