import { type PropType, type VNode } from 'vue';
import { type MonthItem, type QuarterItem, type YearItem } from '../utils';
declare const _default: import("vue").DefineComponent<{
    type: {
        type: PropType<"monthrange" | "yearrange" | "quarterrange">;
        required: true;
    };
    defaultCalendarStartTime: NumberConstructor;
    defaultCalendarEndTime: NumberConstructor;
    bindCalendarMonths: BooleanConstructor;
    actions: {
        readonly type: ArrayConstructor;
        readonly default: () => string[];
    };
    active: BooleanConstructor;
    dateFormat: StringConstructor;
    timerPickerFormat: {
        readonly type: StringConstructor;
        readonly value: "HH:mm:ss";
    };
    value: {
        readonly type: PropType<import("../interface").Value | null>;
        readonly default: null;
    };
    shortcuts: PropType<import("../interface").Shortcuts>;
    defaultTime: PropType<import("../interface").DefaultTime>;
    inputReadonly: BooleanConstructor;
    onClear: FunctionConstructor;
    onConfirm: PropType<(value: import("../interface").Value | null) => void>;
    onClose: PropType<import("../interface").OnClose>;
    onTabOut: FunctionConstructor;
    onUpdateValue: {
        readonly type: PropType<import("../interface").OnPanelUpdateValue>;
        readonly required: true;
    };
    themeClass: StringConstructor;
    onRender: PropType<(() => void) | undefined>;
    panel: BooleanConstructor;
    onNextMonth: PropType<() => void>;
    onPrevMonth: PropType<() => void>;
    onNextYear: PropType<() => void>;
    onPrevYear: PropType<() => void>;
}, {
    renderItem: (item: YearItem | MonthItem | QuarterItem, i: number, mergedClsPrefix: string, type: "start" | "end") => VNode;
    startDateDisplayString: import("vue").Ref<string>;
    endDateInput: import("vue").Ref<string>;
    timePickerSize: import("vue").Ref<"small" | "medium" | "large">;
    startTimeValue: import("vue").ComputedRef<number | null>;
    endTimeValue: import("vue").ComputedRef<number | null>;
    datePickerSlots: Readonly<{
        [name: string]: import("vue").Slot<any> | undefined;
    }>;
    shortcuts: import("vue").ComputedRef<import("../interface").Shortcuts | undefined>;
    startCalendarDateTime: import("vue").Ref<number>;
    endCalendarDateTime: import("vue").Ref<number>;
    justifyColumnsScrollState: {
        (value: [number, number], type: "start" | "end"): void;
        (): void;
    };
    handleFocusDetectorFocus: () => void;
    handleStartTimePickerChange: (value: number | null) => void;
    handleEndTimePickerChange: (value: number | null) => void;
    handleStartDateInput: (value: string) => void;
    handleStartDateInputBlur: () => void;
    handleEndDateInput: (value: string) => void;
    handleEndDateInputBlur: () => void;
    handleStartYearVlScroll: () => void;
    handleEndYearVlScroll: () => void;
    virtualListContainer: (type: "start" | "end") => HTMLElement | null;
    virtualListContent: (type: "start" | "end") => HTMLElement | null;
    onUpdateStartCalendarValue: (value: number) => void;
    onUpdateEndCalendarValue: (value: number) => void;
    startYearScrollbarRef: import("vue").Ref<import("../../../_internal").ScrollbarInst | null>;
    endYearScrollbarRef: import("vue").Ref<import("../../../_internal").ScrollbarInst | null>;
    startMonthScrollbarRef: import("vue").Ref<import("../../../_internal").ScrollbarInst | null>;
    endMonthScrollbarRef: import("vue").Ref<import("../../../_internal").ScrollbarInst | null>;
    startYearVlRef: import("vue").Ref<import("vueuc").VVirtualListInst | null>;
    endYearVlRef: import("vue").Ref<import("vueuc").VVirtualListInst | null>;
    isDateDisabled: import("vue").Ref<import("../interface").IsDateDisabled | undefined>;
    isStartHourDisabled: import("vue").ComputedRef<import("../../../time-picker/src/interface").IsHourDisabled | undefined>;
    isEndHourDisabled: import("vue").ComputedRef<import("../../../time-picker/src/interface").IsHourDisabled | undefined>;
    isStartMinuteDisabled: import("vue").ComputedRef<import("../../../time-picker/src/interface").IsMinuteDisabled | undefined>;
    isEndMinuteDisabled: import("vue").ComputedRef<import("../../../time-picker/src/interface").IsMinuteDisabled | undefined>;
    isStartSecondDisabled: import("vue").ComputedRef<import("../../../time-picker/src/interface").IsSecondDisabled | undefined>;
    isEndSecondDisabled: import("vue").ComputedRef<import("../../../time-picker/src/interface").IsSecondDisabled | undefined>;
    isStartDateInvalid: import("vue").ComputedRef<boolean>;
    isEndDateInvalid: import("vue").ComputedRef<boolean>;
    isStartTimeInvalid: import("vue").ComputedRef<boolean>;
    isEndTimeInvalid: import("vue").ComputedRef<boolean>;
    isStartValueInvalid: import("vue").ComputedRef<boolean>;
    isEndValueInvalid: import("vue").ComputedRef<boolean>;
    isRangeInvalid: import("vue").ComputedRef<boolean>;
    mergedTheme: import("vue").Ref<{
        common: import("../../..").ThemeCommonVars;
        self: {
            itemFontSize: string;
            calendarDaysFontSize: string;
            calendarTitleFontSize: string;
            itemTextColor: string;
            itemTextColorDisabled: string;
            itemTextColorActive: string;
            itemTextColorCurrent: string;
            itemColorIncluded: string;
            itemColorHover: string;
            itemColorDisabled: string;
            itemColorActive: string;
            itemBorderRadius: string;
            panelColor: string;
            panelTextColor: string;
            arrowColor: string;
            calendarTitleTextColor: string;
            calendarTitleColorHover: string;
            calendarDaysTextColor: string;
            panelHeaderDividerColor: string;
            calendarDaysDividerColor: string;
            calendarDividerColor: string;
            panelActionDividerColor: string;
            panelBoxShadow: string;
            panelBorderRadius: string;
            calendarTitleFontWeight: string;
            scrollItemBorderRadius: string;
            iconColor: string;
            iconColorDisabled: string;
            itemSize: string;
            itemCellWidth: string;
            itemCellHeight: string;
            scrollItemWidth: string;
            scrollItemHeight: string;
            panelExtraFooterPadding: string;
            panelActionPadding: string;
            calendarTitlePadding: string;
            calendarTitleHeight: string;
            arrowSize: string;
            panelHeaderPadding: string;
            calendarDaysHeight: string;
            calendarTitleGridTempateColumns: string;
            calendarLeftPaddingDate: string;
            calendarLeftPaddingDatetime: string;
            calendarLeftPaddingDaterange: string;
            calendarLeftPaddingDatetimerange: string;
            calendarLeftPaddingMonth: string;
            calendarLeftPaddingYear: string;
            calendarLeftPaddingQuarter: string;
            calendarLeftPaddingMonthrange: string;
            calendarLeftPaddingQuarterrange: string;
            calendarLeftPaddingYearrange: string;
            calendarLeftPaddingWeek: string;
            calendarRightPaddingDate: string;
            calendarRightPaddingDatetime: string;
            calendarRightPaddingDaterange: string;
            calendarRightPaddingDatetimerange: string;
            calendarRightPaddingMonth: string;
            calendarRightPaddingYear: string;
            calendarRightPaddingQuarter: string;
            calendarRightPaddingMonthrange: string;
            calendarRightPaddingQuarterrange: string;
            calendarRightPaddingYearrange: string;
            calendarRightPaddingWeek: string;
        };
        peers: {
            Input: import("../../../_mixins").Theme<"Input", {
                countTextColorDisabled: string;
                countTextColor: string;
                heightTiny: string;
                heightSmall: string;
                heightMedium: string;
                heightLarge: string;
                fontSizeTiny: string;
                fontSizeSmall: string;
                fontSizeMedium: string;
                fontSizeLarge: string;
                lineHeight: string;
                lineHeightTextarea: string;
                borderRadius: string;
                iconSize: string;
                groupLabelColor: string;
                groupLabelTextColor: string;
                textColor: string;
                textColorDisabled: string;
                textDecorationColor: string;
                caretColor: string;
                placeholderColor: string;
                placeholderColorDisabled: string;
                color: string;
                colorDisabled: string;
                colorFocus: string;
                groupLabelBorder: string;
                border: string;
                borderHover: string;
                borderDisabled: string;
                borderFocus: string;
                boxShadowFocus: string;
                loadingColor: string;
                loadingColorWarning: string;
                borderWarning: string;
                borderHoverWarning: string;
                colorFocusWarning: string;
                borderFocusWarning: string;
                boxShadowFocusWarning: string;
                caretColorWarning: string;
                loadingColorError: string;
                borderError: string;
                borderHoverError: string;
                colorFocusError: string;
                borderFocusError: string;
                boxShadowFocusError: string;
                caretColorError: string;
                clearColor: string;
                clearColorHover: string;
                clearColorPressed: string;
                iconColor: string;
                iconColorDisabled: string;
                iconColorHover: string;
                iconColorPressed: string;
                suffixTextColor: string;
                paddingTiny: string;
                paddingSmall: string;
                paddingMedium: string;
                paddingLarge: string;
                clearSize: string;
            }, any>;
            Button: import("../../../_mixins").Theme<"Button", {
                heightTiny: string;
                heightSmall: string;
                heightMedium: string;
                heightLarge: string;
                borderRadiusTiny: string;
                borderRadiusSmall: string;
                borderRadiusMedium: string;
                borderRadiusLarge: string;
                fontSizeTiny: string;
                fontSizeSmall: string;
                fontSizeMedium: string;
                fontSizeLarge: string;
                opacityDisabled: string;
                colorOpacitySecondary: string;
                colorOpacitySecondaryHover: string;
                colorOpacitySecondaryPressed: string;
                colorSecondary: string;
                colorSecondaryHover: string;
                colorSecondaryPressed: string;
                colorTertiary: string;
                colorTertiaryHover: string;
                colorTertiaryPressed: string;
                colorQuaternary: string;
                colorQuaternaryHover: string;
                colorQuaternaryPressed: string;
                color: string;
                colorHover: string;
                colorPressed: string;
                colorFocus: string;
                colorDisabled: string;
                textColor: string;
                textColorTertiary: string;
                textColorHover: string;
                textColorPressed: string;
                textColorFocus: string;
                textColorDisabled: string;
                textColorText: string;
                textColorTextHover: string;
                textColorTextPressed: string;
                textColorTextFocus: string;
                textColorTextDisabled: string;
                textColorGhost: string;
                textColorGhostHover: string;
                textColorGhostPressed: string;
                textColorGhostFocus: string;
                textColorGhostDisabled: string;
                border: string;
                borderHover: string;
                borderPressed: string;
                borderFocus: string;
                borderDisabled: string;
                rippleColor: string;
                colorPrimary: string;
                colorHoverPrimary: string;
                colorPressedPrimary: string;
                colorFocusPrimary: string;
                colorDisabledPrimary: string;
                textColorPrimary: string;
                textColorHoverPrimary: string;
                textColorPressedPrimary: string;
                textColorFocusPrimary: string;
                textColorDisabledPrimary: string;
                textColorTextPrimary: string;
                textColorTextHoverPrimary: string;
                textColorTextPressedPrimary: string;
                textColorTextFocusPrimary: string;
                textColorTextDisabledPrimary: string;
                textColorGhostPrimary: string;
                textColorGhostHoverPrimary: string;
                textColorGhostPressedPrimary: string;
                textColorGhostFocusPrimary: string;
                textColorGhostDisabledPrimary: string;
                borderPrimary: string;
                borderHoverPrimary: string;
                borderPressedPrimary: string;
                borderFocusPrimary: string;
                borderDisabledPrimary: string;
                rippleColorPrimary: string;
                colorInfo: string;
                colorHoverInfo: string;
                colorPressedInfo: string;
                colorFocusInfo: string;
                colorDisabledInfo: string;
                textColorInfo: string;
                textColorHoverInfo: string;
                textColorPressedInfo: string;
                textColorFocusInfo: string;
                textColorDisabledInfo: string;
                textColorTextInfo: string;
                textColorTextHoverInfo: string;
                textColorTextPressedInfo: string;
                textColorTextFocusInfo: string;
                textColorTextDisabledInfo: string;
                textColorGhostInfo: string;
                textColorGhostHoverInfo: string;
                textColorGhostPressedInfo: string;
                textColorGhostFocusInfo: string;
                textColorGhostDisabledInfo: string;
                borderInfo: string;
                borderHoverInfo: string;
                borderPressedInfo: string;
                borderFocusInfo: string;
                borderDisabledInfo: string;
                rippleColorInfo: string;
                colorSuccess: string;
                colorHoverSuccess: string;
                colorPressedSuccess: string;
                colorFocusSuccess: string;
                colorDisabledSuccess: string;
                textColorSuccess: string;
                textColorHoverSuccess: string;
                textColorPressedSuccess: string;
                textColorFocusSuccess: string;
                textColorDisabledSuccess: string;
                textColorTextSuccess: string;
                textColorTextHoverSuccess: string;
                textColorTextPressedSuccess: string;
                textColorTextFocusSuccess: string;
                textColorTextDisabledSuccess: string;
                textColorGhostSuccess: string;
                textColorGhostHoverSuccess: string;
                textColorGhostPressedSuccess: string;
                textColorGhostFocusSuccess: string;
                textColorGhostDisabledSuccess: string;
                borderSuccess: string;
                borderHoverSuccess: string;
                borderPressedSuccess: string;
                borderFocusSuccess: string;
                borderDisabledSuccess: string;
                rippleColorSuccess: string;
                colorWarning: string;
                colorHoverWarning: string;
                colorPressedWarning: string;
                colorFocusWarning: string;
                colorDisabledWarning: string;
                textColorWarning: string;
                textColorHoverWarning: string;
                textColorPressedWarning: string;
                textColorFocusWarning: string;
                textColorDisabledWarning: string;
                textColorTextWarning: string;
                textColorTextHoverWarning: string;
                textColorTextPressedWarning: string;
                textColorTextFocusWarning: string;
                textColorTextDisabledWarning: string;
                textColorGhostWarning: string;
                textColorGhostHoverWarning: string;
                textColorGhostPressedWarning: string;
                textColorGhostFocusWarning: string;
                textColorGhostDisabledWarning: string;
                borderWarning: string;
                borderHoverWarning: string;
                borderPressedWarning: string;
                borderFocusWarning: string;
                borderDisabledWarning: string;
                rippleColorWarning: string;
                colorError: string;
                colorHoverError: string;
                colorPressedError: string;
                colorFocusError: string;
                colorDisabledError: string;
                textColorError: string;
                textColorHoverError: string;
                textColorPressedError: string;
                textColorFocusError: string;
                textColorDisabledError: string;
                textColorTextError: string;
                textColorTextHoverError: string;
                textColorTextPressedError: string;
                textColorTextFocusError: string;
                textColorTextDisabledError: string;
                textColorGhostError: string;
                textColorGhostHoverError: string;
                textColorGhostPressedError: string;
                textColorGhostFocusError: string;
                textColorGhostDisabledError: string;
                borderError: string;
                borderHoverError: string;
                borderPressedError: string;
                borderFocusError: string;
                borderDisabledError: string;
                rippleColorError: string;
                waveOpacity: string;
                fontWeight: string;
                fontWeightStrong: string;
                paddingTiny: string;
                paddingSmall: string;
                paddingMedium: string;
                paddingLarge: string;
                paddingRoundTiny: string;
                paddingRoundSmall: string;
                paddingRoundMedium: string;
                paddingRoundLarge: string;
                iconMarginTiny: string;
                iconMarginSmall: string;
                iconMarginMedium: string;
                iconMarginLarge: string;
                iconSizeTiny: string;
                iconSizeSmall: string;
                iconSizeMedium: string;
                iconSizeLarge: string;
                rippleDuration: string;
            }, any>;
            TimePicker: import("../../../_mixins").Theme<"TimePicker", {
                panelColor: string;
                panelBoxShadow: string;
                panelDividerColor: string;
                itemTextColor: string;
                itemTextColorActive: string;
                itemColorHover: string;
                itemOpacityDisabled: string;
                itemBorderRadius: string;
                borderRadius: string;
                iconColor: string;
                iconColorDisabled: string;
                itemFontSize: string;
                itemHeight: string;
                itemWidth: string;
                panelActionPadding: string;
            }, {
                Scrollbar: import("../../../_mixins").Theme<"Scrollbar", {
                    height: string;
                    width: string;
                    borderRadius: string;
                    color: string;
                    colorHover: string;
                    railInsetHorizontalBottom: string;
                    railInsetHorizontalTop: string;
                    railInsetVerticalRight: string;
                    railInsetVerticalLeft: string;
                    railColor: string;
                }, any>;
                Button: import("../../../_mixins").Theme<"Button", {
                    heightTiny: string;
                    heightSmall: string;
                    heightMedium: string;
                    heightLarge: string;
                    borderRadiusTiny: string;
                    borderRadiusSmall: string;
                    borderRadiusMedium: string;
                    borderRadiusLarge: string;
                    fontSizeTiny: string;
                    fontSizeSmall: string;
                    fontSizeMedium: string;
                    fontSizeLarge: string;
                    opacityDisabled: string;
                    colorOpacitySecondary: string;
                    colorOpacitySecondaryHover: string;
                    colorOpacitySecondaryPressed: string;
                    colorSecondary: string;
                    colorSecondaryHover: string;
                    colorSecondaryPressed: string;
                    colorTertiary: string;
                    colorTertiaryHover: string;
                    colorTertiaryPressed: string;
                    colorQuaternary: string;
                    colorQuaternaryHover: string;
                    colorQuaternaryPressed: string;
                    color: string;
                    colorHover: string;
                    colorPressed: string;
                    colorFocus: string;
                    colorDisabled: string;
                    textColor: string;
                    textColorTertiary: string;
                    textColorHover: string;
                    textColorPressed: string;
                    textColorFocus: string;
                    textColorDisabled: string;
                    textColorText: string;
                    textColorTextHover: string;
                    textColorTextPressed: string;
                    textColorTextFocus: string;
                    textColorTextDisabled: string;
                    textColorGhost: string;
                    textColorGhostHover: string;
                    textColorGhostPressed: string;
                    textColorGhostFocus: string;
                    textColorGhostDisabled: string;
                    border: string;
                    borderHover: string;
                    borderPressed: string;
                    borderFocus: string;
                    borderDisabled: string;
                    rippleColor: string;
                    colorPrimary: string;
                    colorHoverPrimary: string;
                    colorPressedPrimary: string;
                    colorFocusPrimary: string;
                    colorDisabledPrimary: string;
                    textColorPrimary: string;
                    textColorHoverPrimary: string;
                    textColorPressedPrimary: string;
                    textColorFocusPrimary: string;
                    textColorDisabledPrimary: string;
                    textColorTextPrimary: string;
                    textColorTextHoverPrimary: string;
                    textColorTextPressedPrimary: string;
                    textColorTextFocusPrimary: string;
                    textColorTextDisabledPrimary: string;
                    textColorGhostPrimary: string;
                    textColorGhostHoverPrimary: string;
                    textColorGhostPressedPrimary: string;
                    textColorGhostFocusPrimary: string;
                    textColorGhostDisabledPrimary: string;
                    borderPrimary: string;
                    borderHoverPrimary: string;
                    borderPressedPrimary: string;
                    borderFocusPrimary: string;
                    borderDisabledPrimary: string;
                    rippleColorPrimary: string;
                    colorInfo: string;
                    colorHoverInfo: string;
                    colorPressedInfo: string;
                    colorFocusInfo: string;
                    colorDisabledInfo: string;
                    textColorInfo: string;
                    textColorHoverInfo: string;
                    textColorPressedInfo: string;
                    textColorFocusInfo: string;
                    textColorDisabledInfo: string;
                    textColorTextInfo: string;
                    textColorTextHoverInfo: string;
                    textColorTextPressedInfo: string;
                    textColorTextFocusInfo: string;
                    textColorTextDisabledInfo: string;
                    textColorGhostInfo: string;
                    textColorGhostHoverInfo: string;
                    textColorGhostPressedInfo: string;
                    textColorGhostFocusInfo: string;
                    textColorGhostDisabledInfo: string;
                    borderInfo: string;
                    borderHoverInfo: string;
                    borderPressedInfo: string;
                    borderFocusInfo: string;
                    borderDisabledInfo: string;
                    rippleColorInfo: string;
                    colorSuccess: string;
                    colorHoverSuccess: string;
                    colorPressedSuccess: string;
                    colorFocusSuccess: string;
                    colorDisabledSuccess: string;
                    textColorSuccess: string;
                    textColorHoverSuccess: string;
                    textColorPressedSuccess: string;
                    textColorFocusSuccess: string;
                    textColorDisabledSuccess: string;
                    textColorTextSuccess: string;
                    textColorTextHoverSuccess: string;
                    textColorTextPressedSuccess: string;
                    textColorTextFocusSuccess: string;
                    textColorTextDisabledSuccess: string;
                    textColorGhostSuccess: string;
                    textColorGhostHoverSuccess: string;
                    textColorGhostPressedSuccess: string;
                    textColorGhostFocusSuccess: string;
                    textColorGhostDisabledSuccess: string;
                    borderSuccess: string;
                    borderHoverSuccess: string;
                    borderPressedSuccess: string;
                    borderFocusSuccess: string;
                    borderDisabledSuccess: string;
                    rippleColorSuccess: string;
                    colorWarning: string;
                    colorHoverWarning: string;
                    colorPressedWarning: string;
                    colorFocusWarning: string;
                    colorDisabledWarning: string;
                    textColorWarning: string;
                    textColorHoverWarning: string;
                    textColorPressedWarning: string;
                    textColorFocusWarning: string;
                    textColorDisabledWarning: string;
                    textColorTextWarning: string;
                    textColorTextHoverWarning: string;
                    textColorTextPressedWarning: string;
                    textColorTextFocusWarning: string;
                    textColorTextDisabledWarning: string;
                    textColorGhostWarning: string;
                    textColorGhostHoverWarning: string;
                    textColorGhostPressedWarning: string;
                    textColorGhostFocusWarning: string;
                    textColorGhostDisabledWarning: string;
                    borderWarning: string;
                    borderHoverWarning: string;
                    borderPressedWarning: string;
                    borderFocusWarning: string;
                    borderDisabledWarning: string;
                    rippleColorWarning: string;
                    colorError: string;
                    colorHoverError: string;
                    colorPressedError: string;
                    colorFocusError: string;
                    colorDisabledError: string;
                    textColorError: string;
                    textColorHoverError: string;
                    textColorPressedError: string;
                    textColorFocusError: string;
                    textColorDisabledError: string;
                    textColorTextError: string;
                    textColorTextHoverError: string;
                    textColorTextPressedError: string;
                    textColorTextFocusError: string;
                    textColorTextDisabledError: string;
                    textColorGhostError: string;
                    textColorGhostHoverError: string;
                    textColorGhostPressedError: string;
                    textColorGhostFocusError: string;
                    textColorGhostDisabledError: string;
                    borderError: string;
                    borderHoverError: string;
                    borderPressedError: string;
                    borderFocusError: string;
                    borderDisabledError: string;
                    rippleColorError: string;
                    waveOpacity: string;
                    fontWeight: string;
                    fontWeightStrong: string;
                    paddingTiny: string;
                    paddingSmall: string;
                    paddingMedium: string;
                    paddingLarge: string;
                    paddingRoundTiny: string;
                    paddingRoundSmall: string;
                    paddingRoundMedium: string;
                    paddingRoundLarge: string;
                    iconMarginTiny: string;
                    iconMarginSmall: string;
                    iconMarginMedium: string;
                    iconMarginLarge: string;
                    iconSizeTiny: string;
                    iconSizeSmall: string;
                    iconSizeMedium: string;
                    iconSizeLarge: string;
                    rippleDuration: string;
                }, any>;
                Input: import("../../../_mixins").Theme<"Input", {
                    countTextColorDisabled: string;
                    countTextColor: string;
                    heightTiny: string;
                    heightSmall: string;
                    heightMedium: string;
                    heightLarge: string;
                    fontSizeTiny: string;
                    fontSizeSmall: string;
                    fontSizeMedium: string;
                    fontSizeLarge: string;
                    lineHeight: string;
                    lineHeightTextarea: string;
                    borderRadius: string;
                    iconSize: string;
                    groupLabelColor: string;
                    groupLabelTextColor: string;
                    textColor: string;
                    textColorDisabled: string;
                    textDecorationColor: string;
                    caretColor: string;
                    placeholderColor: string;
                    placeholderColorDisabled: string;
                    color: string;
                    colorDisabled: string;
                    colorFocus: string;
                    groupLabelBorder: string;
                    border: string;
                    borderHover: string;
                    borderDisabled: string;
                    borderFocus: string;
                    boxShadowFocus: string;
                    loadingColor: string;
                    loadingColorWarning: string;
                    borderWarning: string;
                    borderHoverWarning: string;
                    colorFocusWarning: string;
                    borderFocusWarning: string;
                    boxShadowFocusWarning: string;
                    caretColorWarning: string;
                    loadingColorError: string;
                    borderError: string;
                    borderHoverError: string;
                    colorFocusError: string;
                    borderFocusError: string;
                    boxShadowFocusError: string;
                    caretColorError: string;
                    clearColor: string;
                    clearColorHover: string;
                    clearColorPressed: string;
                    iconColor: string;
                    iconColorDisabled: string;
                    iconColorHover: string;
                    iconColorPressed: string;
                    suffixTextColor: string;
                    paddingTiny: string;
                    paddingSmall: string;
                    paddingMedium: string;
                    paddingLarge: string;
                    clearSize: string;
                }, any>;
            }>;
            Scrollbar: import("../../../_mixins").Theme<"Scrollbar", {
                height: string;
                width: string;
                borderRadius: string;
                color: string;
                colorHover: string;
                railInsetHorizontalBottom: string;
                railInsetHorizontalTop: string;
                railInsetVerticalRight: string;
                railInsetVerticalLeft: string;
                railColor: string;
            }, any>;
        };
        peerOverrides: {
            Input?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
            Button?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
            TimePicker?: {
                peers?: {
                    Scrollbar?: import("../../../_mixins/use-theme").ExtractThemeOverrides<import("../../../_mixins").Theme<"Scrollbar", {
                        height: string;
                        width: string;
                        borderRadius: string;
                        color: string;
                        colorHover: string;
                        railInsetHorizontalBottom: string;
                        railInsetHorizontalTop: string;
                        railInsetVerticalRight: string;
                        railInsetVerticalLeft: string;
                        railColor: string;
                    }, any>> | undefined;
                    Button?: import("../../../_mixins/use-theme").ExtractThemeOverrides<import("../../../_mixins").Theme<"Button", {
                        heightTiny: string;
                        heightSmall: string;
                        heightMedium: string;
                        heightLarge: string;
                        borderRadiusTiny: string;
                        borderRadiusSmall: string;
                        borderRadiusMedium: string;
                        borderRadiusLarge: string;
                        fontSizeTiny: string;
                        fontSizeSmall: string;
                        fontSizeMedium: string;
                        fontSizeLarge: string;
                        opacityDisabled: string;
                        colorOpacitySecondary: string;
                        colorOpacitySecondaryHover: string;
                        colorOpacitySecondaryPressed: string;
                        colorSecondary: string;
                        colorSecondaryHover: string;
                        colorSecondaryPressed: string;
                        colorTertiary: string;
                        colorTertiaryHover: string;
                        colorTertiaryPressed: string;
                        colorQuaternary: string;
                        colorQuaternaryHover: string;
                        colorQuaternaryPressed: string;
                        color: string;
                        colorHover: string;
                        colorPressed: string;
                        colorFocus: string;
                        colorDisabled: string;
                        textColor: string;
                        textColorTertiary: string;
                        textColorHover: string;
                        textColorPressed: string;
                        textColorFocus: string;
                        textColorDisabled: string;
                        textColorText: string;
                        textColorTextHover: string;
                        textColorTextPressed: string;
                        textColorTextFocus: string;
                        textColorTextDisabled: string;
                        textColorGhost: string;
                        textColorGhostHover: string;
                        textColorGhostPressed: string;
                        textColorGhostFocus: string;
                        textColorGhostDisabled: string;
                        border: string;
                        borderHover: string;
                        borderPressed: string;
                        borderFocus: string;
                        borderDisabled: string;
                        rippleColor: string;
                        colorPrimary: string;
                        colorHoverPrimary: string;
                        colorPressedPrimary: string;
                        colorFocusPrimary: string;
                        colorDisabledPrimary: string;
                        textColorPrimary: string;
                        textColorHoverPrimary: string;
                        textColorPressedPrimary: string;
                        textColorFocusPrimary: string;
                        textColorDisabledPrimary: string;
                        textColorTextPrimary: string;
                        textColorTextHoverPrimary: string;
                        textColorTextPressedPrimary: string;
                        textColorTextFocusPrimary: string;
                        textColorTextDisabledPrimary: string;
                        textColorGhostPrimary: string;
                        textColorGhostHoverPrimary: string;
                        textColorGhostPressedPrimary: string;
                        textColorGhostFocusPrimary: string;
                        textColorGhostDisabledPrimary: string;
                        borderPrimary: string;
                        borderHoverPrimary: string;
                        borderPressedPrimary: string;
                        borderFocusPrimary: string;
                        borderDisabledPrimary: string;
                        rippleColorPrimary: string;
                        colorInfo: string;
                        colorHoverInfo: string;
                        colorPressedInfo: string;
                        colorFocusInfo: string;
                        colorDisabledInfo: string;
                        textColorInfo: string;
                        textColorHoverInfo: string;
                        textColorPressedInfo: string;
                        textColorFocusInfo: string;
                        textColorDisabledInfo: string;
                        textColorTextInfo: string;
                        textColorTextHoverInfo: string;
                        textColorTextPressedInfo: string;
                        textColorTextFocusInfo: string;
                        textColorTextDisabledInfo: string;
                        textColorGhostInfo: string;
                        textColorGhostHoverInfo: string;
                        textColorGhostPressedInfo: string;
                        textColorGhostFocusInfo: string;
                        textColorGhostDisabledInfo: string;
                        borderInfo: string;
                        borderHoverInfo: string;
                        borderPressedInfo: string;
                        borderFocusInfo: string;
                        borderDisabledInfo: string;
                        rippleColorInfo: string;
                        colorSuccess: string;
                        colorHoverSuccess: string;
                        colorPressedSuccess: string;
                        colorFocusSuccess: string;
                        colorDisabledSuccess: string;
                        textColorSuccess: string;
                        textColorHoverSuccess: string;
                        textColorPressedSuccess: string;
                        textColorFocusSuccess: string;
                        textColorDisabledSuccess: string;
                        textColorTextSuccess: string;
                        textColorTextHoverSuccess: string;
                        textColorTextPressedSuccess: string;
                        textColorTextFocusSuccess: string;
                        textColorTextDisabledSuccess: string;
                        textColorGhostSuccess: string;
                        textColorGhostHoverSuccess: string;
                        textColorGhostPressedSuccess: string;
                        textColorGhostFocusSuccess: string;
                        textColorGhostDisabledSuccess: string;
                        borderSuccess: string;
                        borderHoverSuccess: string;
                        borderPressedSuccess: string;
                        borderFocusSuccess: string;
                        borderDisabledSuccess: string;
                        rippleColorSuccess: string;
                        colorWarning: string;
                        colorHoverWarning: string;
                        colorPressedWarning: string;
                        colorFocusWarning: string;
                        colorDisabledWarning: string;
                        textColorWarning: string;
                        textColorHoverWarning: string;
                        textColorPressedWarning: string;
                        textColorFocusWarning: string;
                        textColorDisabledWarning: string;
                        textColorTextWarning: string;
                        textColorTextHoverWarning: string;
                        textColorTextPressedWarning: string;
                        textColorTextFocusWarning: string;
                        textColorTextDisabledWarning: string;
                        textColorGhostWarning: string;
                        textColorGhostHoverWarning: string;
                        textColorGhostPressedWarning: string;
                        textColorGhostFocusWarning: string;
                        textColorGhostDisabledWarning: string;
                        borderWarning: string;
                        borderHoverWarning: string;
                        borderPressedWarning: string;
                        borderFocusWarning: string;
                        borderDisabledWarning: string;
                        rippleColorWarning: string;
                        colorError: string;
                        colorHoverError: string;
                        colorPressedError: string;
                        colorFocusError: string;
                        colorDisabledError: string;
                        textColorError: string;
                        textColorHoverError: string;
                        textColorPressedError: string;
                        textColorFocusError: string;
                        textColorDisabledError: string;
                        textColorTextError: string;
                        textColorTextHoverError: string;
                        textColorTextPressedError: string;
                        textColorTextFocusError: string;
                        textColorTextDisabledError: string;
                        textColorGhostError: string;
                        textColorGhostHoverError: string;
                        textColorGhostPressedError: string;
                        textColorGhostFocusError: string;
                        textColorGhostDisabledError: string;
                        borderError: string;
                        borderHoverError: string;
                        borderPressedError: string;
                        borderFocusError: string;
                        borderDisabledError: string;
                        rippleColorError: string;
                        waveOpacity: string;
                        fontWeight: string;
                        fontWeightStrong: string;
                        paddingTiny: string;
                        paddingSmall: string;
                        paddingMedium: string;
                        paddingLarge: string;
                        paddingRoundTiny: string;
                        paddingRoundSmall: string;
                        paddingRoundMedium: string;
                        paddingRoundLarge: string;
                        iconMarginTiny: string;
                        iconMarginSmall: string;
                        iconMarginMedium: string;
                        iconMarginLarge: string;
                        iconSizeTiny: string;
                        iconSizeSmall: string;
                        iconSizeMedium: string;
                        iconSizeLarge: string;
                        rippleDuration: string;
                    }, any>> | undefined;
                    Input?: import("../../../_mixins/use-theme").ExtractThemeOverrides<import("../../../_mixins").Theme<"Input", {
                        countTextColorDisabled: string;
                        countTextColor: string;
                        heightTiny: string;
                        heightSmall: string;
                        heightMedium: string;
                        heightLarge: string;
                        fontSizeTiny: string;
                        fontSizeSmall: string;
                        fontSizeMedium: string;
                        fontSizeLarge: string;
                        lineHeight: string;
                        lineHeightTextarea: string;
                        borderRadius: string;
                        iconSize: string;
                        groupLabelColor: string;
                        groupLabelTextColor: string;
                        textColor: string;
                        textColorDisabled: string;
                        textDecorationColor: string;
                        caretColor: string;
                        placeholderColor: string;
                        placeholderColorDisabled: string;
                        color: string;
                        colorDisabled: string;
                        colorFocus: string;
                        groupLabelBorder: string;
                        border: string;
                        borderHover: string;
                        borderDisabled: string;
                        borderFocus: string;
                        boxShadowFocus: string;
                        loadingColor: string;
                        loadingColorWarning: string;
                        borderWarning: string;
                        borderHoverWarning: string;
                        colorFocusWarning: string;
                        borderFocusWarning: string;
                        boxShadowFocusWarning: string;
                        caretColorWarning: string;
                        loadingColorError: string;
                        borderError: string;
                        borderHoverError: string;
                        colorFocusError: string;
                        borderFocusError: string;
                        boxShadowFocusError: string;
                        caretColorError: string;
                        clearColor: string;
                        clearColorHover: string;
                        clearColorPressed: string;
                        iconColor: string;
                        iconColorDisabled: string;
                        iconColorHover: string;
                        iconColorPressed: string;
                        suffixTextColor: string;
                        paddingTiny: string;
                        paddingSmall: string;
                        paddingMedium: string;
                        paddingLarge: string;
                        clearSize: string;
                    }, any>> | undefined;
                } | undefined;
            } | undefined;
            Scrollbar?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
        };
    }>;
    mergedClsPrefix: import("vue").Ref<string>;
    dateFnsOptions: import("vue").ComputedRef<{
        locale: import("date-fns").Locale;
    }>;
    timePickerProps: import("vue").Ref<import("../../..").TimePickerProps | [import("../../..").TimePickerProps, import("../../..").TimePickerProps] | undefined>;
    selfRef: import("vue").Ref<HTMLElement | null>;
    locale: import("vue").Ref<{
        yearFormat: string;
        monthFormat: string;
        dayFormat: string;
        yearTypeFormat: string;
        monthTypeFormat: string;
        dateFormat: string;
        dateTimeFormat: string;
        quarterFormat: string;
        weekFormat: string;
        clear: string;
        now: string;
        confirm: string;
        selectTime: string;
        selectDate: string;
        datePlaceholder: string;
        datetimePlaceholder: string;
        monthPlaceholder: string;
        yearPlaceholder: string;
        quarterPlaceholder: string;
        weekPlaceholder: string;
        startDatePlaceholder: string;
        endDatePlaceholder: string;
        startDatetimePlaceholder: string;
        endDatetimePlaceholder: string;
        startMonthPlaceholder: string;
        endMonthPlaceholder: string;
        monthBeforeYear: boolean;
        firstDayOfWeek: 0 | 1 | 2 | 3 | 4 | 5 | 6;
        today: string;
    }>;
    doConfirm: () => void;
    doClose: (disableUpdateOnClose?: boolean) => void;
    doUpdateValue: (value: import("../interface").Value | null, doUpdate: boolean) => void;
    doTabOut: () => void;
    handleClearClick: () => void;
    disableTransitionOneTick: () => void;
    handlePanelKeyDown: (e: KeyboardEvent) => void;
    handlePanelFocus: (e: FocusEvent) => void;
    cachePendingValue: () => void;
    clearPendingValue: () => void;
    restorePendingValue: () => void;
    getShortcutValue: (shortcut: import("../interface").Shortcuts[string]) => number | [number, number] | readonly [number, number];
    handleShortcutMouseleave: () => void;
    showMonthYearPanel: import("vue").Ref<boolean>;
    handleOpenQuickSelectMonthPanel: () => void;
    startDatesElRef: import("vue").Ref<HTMLElement | null>;
    endDatesElRef: import("vue").Ref<HTMLElement | null>;
    handleDateClick: (dateItem: import("../utils").DateItem) => void;
    handleColItemClick: (dateItem: MonthItem | QuarterItem | YearItem, clickType: "start" | "end") => void;
    handleDateMouseEnter: (dateItem: import("../utils").DateItem) => void;
    handleConfirmClick: () => void;
    startCalendarPrevYear: () => void;
    startCalendarPrevMonth: () => void;
    startCalendarNextYear: () => void;
    startCalendarNextMonth: () => void;
    endCalendarPrevYear: () => void;
    endCalendarPrevMonth: () => void;
    endCalendarNextMonth: () => void;
    endCalendarNextYear: () => void;
    mergedIsDateDisabled: (ts: number) => boolean;
    changeStartEndTime: (startTime: number, endTime: number, source: "shortcutPreview" | "wipPreview" | "done") => void;
    ranges: import("vue").Ref<Record<string, [number, number]> | undefined>;
    startCalendarMonth: import("vue").ComputedRef<string>;
    startCalendarYear: import("vue").ComputedRef<string>;
    endCalendarMonth: import("vue").ComputedRef<string>;
    endCalendarYear: import("vue").ComputedRef<string>;
    weekdays: import("vue").ComputedRef<string[]>;
    startDateArray: import("vue").ComputedRef<import("../utils").DateItem[]>;
    endDateArray: import("vue").ComputedRef<import("../utils").DateItem[]>;
    startYearArray: import("vue").ComputedRef<YearItem[]>;
    startMonthArray: import("vue").ComputedRef<MonthItem[]>;
    startQuarterArray: import("vue").ComputedRef<QuarterItem[]>;
    endYearArray: import("vue").ComputedRef<YearItem[]>;
    endMonthArray: import("vue").ComputedRef<MonthItem[]>;
    endQuarterArray: import("vue").ComputedRef<QuarterItem[]>;
    isSelecting: import("vue").Ref<boolean>;
    handleRangeShortcutMouseenter: (shortcut: import("../interface").Shortcuts[string]) => void;
    handleRangeShortcutClick: (shortcut: import("../interface").Shortcuts[string]) => void;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    type: {
        type: PropType<"monthrange" | "yearrange" | "quarterrange">;
        required: true;
    };
    defaultCalendarStartTime: NumberConstructor;
    defaultCalendarEndTime: NumberConstructor;
    bindCalendarMonths: BooleanConstructor;
    actions: {
        readonly type: ArrayConstructor;
        readonly default: () => string[];
    };
    active: BooleanConstructor;
    dateFormat: StringConstructor;
    timerPickerFormat: {
        readonly type: StringConstructor;
        readonly value: "HH:mm:ss";
    };
    value: {
        readonly type: PropType<import("../interface").Value | null>;
        readonly default: null;
    };
    shortcuts: PropType<import("../interface").Shortcuts>;
    defaultTime: PropType<import("../interface").DefaultTime>;
    inputReadonly: BooleanConstructor;
    onClear: FunctionConstructor;
    onConfirm: PropType<(value: import("../interface").Value | null) => void>;
    onClose: PropType<import("../interface").OnClose>;
    onTabOut: FunctionConstructor;
    onUpdateValue: {
        readonly type: PropType<import("../interface").OnPanelUpdateValue>;
        readonly required: true;
    };
    themeClass: StringConstructor;
    onRender: PropType<(() => void) | undefined>;
    panel: BooleanConstructor;
    onNextMonth: PropType<() => void>;
    onPrevMonth: PropType<() => void>;
    onNextYear: PropType<() => void>;
    onPrevYear: PropType<() => void>;
}>>, {
    value: import("../interface").Value | null;
    active: boolean;
    actions: unknown[];
    inputReadonly: boolean;
    panel: boolean;
    bindCalendarMonths: boolean;
}, {}>;
export default _default;
