/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.adaptsink;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class DefineSinkTypeTransformConfig
implements Serializable {
    public static final String PLUGIN_NAME = "DefineSinkType";
    public static final Option<List<DefineColumnType>> COLUMNS = Options.key((String)"columns").type((TypeReference)new TypeReference<List<DefineColumnType>>(){}).noDefaultValue().withDescription("The columns to be defined, the name and type of the column must be set");
    public static final Option<List<TableTransforms>> MULTI_TABLES = Options.key((String)"table_transform").listType(TableTransforms.class).noDefaultValue().withDescription("The table transform config");
    private List<DefineColumnType> columns;

    public Map<String, DefineColumnType> toMap() {
        return this.columns.stream().collect(Collectors.toMap(DefineColumnType::getColumn, defineColumnType -> defineColumnType));
    }

    public static DefineSinkTypeTransformConfig of(ReadonlyConfig config) {
        List columns = (List)config.get(COLUMNS);
        Preconditions.checkArgument((columns != null && !columns.isEmpty() ? 1 : 0) != 0, (Object)"The columns must be set");
        columns.forEach(defineColumnType -> {
            Preconditions.checkArgument((defineColumnType.getColumn() != null ? 1 : 0) != 0, (Object)"The column name must be set");
            Preconditions.checkArgument((defineColumnType.getType() != null ? 1 : 0) != 0, (Object)"The column type must be set");
        });
        return new DefineSinkTypeTransformConfig(columns);
    }

    public List<DefineColumnType> getColumns() {
        return this.columns;
    }

    public void setColumns(List<DefineColumnType> columns) {
        this.columns = columns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefineSinkTypeTransformConfig)) {
            return false;
        }
        DefineSinkTypeTransformConfig other = (DefineSinkTypeTransformConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DefineColumnType> this$columns = this.getColumns();
        List<DefineColumnType> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefineSinkTypeTransformConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DefineColumnType> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    public String toString() {
        return "DefineSinkTypeTransformConfig(columns=" + this.getColumns() + ")";
    }

    public DefineSinkTypeTransformConfig(List<DefineColumnType> columns) {
        this.columns = columns;
    }

    public static class TableTransforms
    implements Serializable {
        @JsonAlias(value={"table_path"})
        private String tablePath;
        @JsonAlias(value={"columns"})
        private List<DefineColumnType> columns;

        public String getTablePath() {
            return this.tablePath;
        }

        public List<DefineColumnType> getColumns() {
            return this.columns;
        }

        public void setTablePath(String tablePath) {
            this.tablePath = tablePath;
        }

        public void setColumns(List<DefineColumnType> columns) {
            this.columns = columns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableTransforms)) {
                return false;
            }
            TableTransforms other = (TableTransforms)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tablePath = this.getTablePath();
            String other$tablePath = other.getTablePath();
            if (this$tablePath == null ? other$tablePath != null : !this$tablePath.equals(other$tablePath)) {
                return false;
            }
            List<DefineColumnType> this$columns = this.getColumns();
            List<DefineColumnType> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableTransforms;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tablePath = this.getTablePath();
            result = result * 59 + ($tablePath == null ? 43 : $tablePath.hashCode());
            List<DefineColumnType> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        public String toString() {
            return "DefineSinkTypeTransformConfig.TableTransforms(tablePath=" + this.getTablePath() + ", columns=" + this.getColumns() + ")";
        }
    }

    public static class DefineColumnType
    implements Serializable {
        private String column;
        private String type;

        public String getColumn() {
            return this.column;
        }

        public String getType() {
            return this.type;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefineColumnType)) {
                return false;
            }
            DefineColumnType other = (DefineColumnType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DefineColumnType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "DefineSinkTypeTransformConfig.DefineColumnType(column=" + this.getColumn() + ", type=" + this.getType() + ")";
        }

        public DefineColumnType(String column, String type) {
            this.column = column;
            this.type = type;
        }

        public DefineColumnType() {
        }
    }
}

