/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.exception.FakeConnectorException;
import org.apache.seatunnel.connectors.seatunnel.fake.utils.FakeDataRandomUtils;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;

public class FakeDataGenerator {
    private static final String CURRENT_DATE = "CURRENT_DATE";
    private static final String CURRENT_TIME = "CURRENT_TIME";
    private static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private final ObjectMapper OBJECTMAPPER = new ObjectMapper();
    private final CatalogTable catalogTable;
    private final FakeConfig fakeConfig;
    private final JsonDeserializationSchema jsonDeserializationSchema;
    private final FakeDataRandomUtils fakeDataRandomUtils;
    private String tableId;

    public FakeDataGenerator(FakeConfig fakeConfig) {
        this.catalogTable = fakeConfig.getCatalogTable();
        this.tableId = this.catalogTable.getTableId().toTablePath().toString();
        this.fakeConfig = fakeConfig;
        this.jsonDeserializationSchema = fakeConfig.getFakeRows() == null ? null : new JsonDeserializationSchema(this.catalogTable, false, false);
        this.fakeDataRandomUtils = new FakeDataRandomUtils(fakeConfig);
    }

    private SeaTunnelRow convertRow(FakeConfig.RowData rowData) {
        try {
            SeaTunnelRow seaTunnelRow = this.jsonDeserializationSchema.deserialize(rowData.getFieldsJson());
            if (rowData.getKind() != null) {
                seaTunnelRow.setRowKind(RowKind.valueOf((String)rowData.getKind()));
            }
            seaTunnelRow.setTableId(this.tableId);
            return seaTunnelRow;
        }
        catch (IOException e) {
            throw CommonError.jsonOperationError((String)"Fake", (String)rowData.getFieldsJson(), (Throwable)e);
        }
    }

    private SeaTunnelRow randomRow() {
        List physicalColumns = this.catalogTable.getTableSchema().getColumns();
        ArrayList<Object> randomRow = new ArrayList<Object>(physicalColumns.size());
        for (Column column : physicalColumns) {
            randomRow.add(this.randomColumnValue(column));
        }
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(randomRow.toArray());
        seaTunnelRow.setTableId(this.tableId);
        return seaTunnelRow;
    }

    @VisibleForTesting
    public List<SeaTunnelRow> generateFakedRows(int rowNum) {
        ArrayList<SeaTunnelRow> rows = new ArrayList<SeaTunnelRow>();
        this.generateFakedRows(rowNum, rows::add);
        return rows;
    }

    public long generateFakedRows(int rowNum, Consumer<SeaTunnelRow> consumer) {
        long rowCount = 0L;
        if (this.fakeConfig.getFakeRows() != null) {
            SeaTunnelDataType[] fieldTypes = this.catalogTable.getSeaTunnelRowType().getFieldTypes();
            String[] fieldNames = this.catalogTable.getSeaTunnelRowType().getFieldNames();
            for (FakeConfig.RowData rowData : this.fakeConfig.getFakeRows()) {
                this.customField(rowData, fieldTypes, fieldNames);
                consumer.accept(this.convertRow(rowData));
                ++rowCount;
            }
        } else {
            for (int i = 0; i < rowNum; ++i) {
                consumer.accept(this.randomRow());
                ++rowCount;
            }
        }
        return rowCount;
    }

    private void customField(FakeConfig.RowData rowData, SeaTunnelDataType<?>[] fieldTypes, String[] fieldNames) {
        if (rowData.getFieldsJson() == null) {
            return;
        }
        try {
            JsonNode jsonNode = this.OBJECTMAPPER.readTree(rowData.getFieldsJson());
            int arity = fieldTypes.length;
            for (int i = 0; i < arity; ++i) {
                String newValue;
                JsonNode field;
                SeaTunnelDataType<?> fieldType = fieldTypes[i];
                JsonNode jsonNode2 = field = jsonNode.isArray() ? jsonNode.get(i) : jsonNode.get(fieldNames[i]);
                if (field == null || (newValue = this.getNewValueForField(fieldType.getSqlType(), field.asText())) == null) continue;
                jsonNode = this.replaceFieldValue(jsonNode, i, fieldNames[i], newValue);
            }
            rowData.setFieldsJson(jsonNode.toString());
        }
        catch (JsonProcessingException e) {
            throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "The data type of the fake data is not supported", e);
        }
    }

    private String getNewValueForField(SqlType sqlType, String fieldValue) {
        switch (sqlType) {
            case TIME: {
                return fieldValue.equals(CURRENT_TIME) ? LocalTime.now().toString() : null;
            }
            case DATE: {
                return fieldValue.equalsIgnoreCase(CURRENT_DATE) ? LocalDate.now().toString() : null;
            }
            case TIMESTAMP: {
                return fieldValue.equalsIgnoreCase(CURRENT_TIMESTAMP) ? LocalDateTime.now().toString() : null;
            }
            case TIMESTAMP_TZ: {
                return fieldValue.equalsIgnoreCase(CURRENT_TIMESTAMP) ? OffsetDateTime.now().toString() : null;
            }
        }
        return null;
    }

    private JsonNode replaceFieldValue(JsonNode jsonNode, int index, String fieldName, String newValue) {
        JsonNode newFieldNode = (JsonNode)this.OBJECTMAPPER.convertValue((Object)newValue, JsonNode.class);
        if (jsonNode.isArray()) {
            ((ArrayNode)jsonNode).set(index, newFieldNode);
        } else {
            ((ObjectNode)jsonNode).set(fieldName, newFieldNode);
        }
        return jsonNode;
    }

    private Object randomColumnValue(Column column) {
        SeaTunnelDataType fieldType = column.getDataType();
        switch (fieldType.getSqlType()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)fieldType;
                SeaTunnelDataType elementType = arrayType.getElementType();
                int length = this.fakeConfig.getArraySize();
                Object array = Array.newInstance(elementType.getTypeClass(), length);
                for (int i = 0; i < length; ++i) {
                    Object value = this.randomColumnValue(column.copy(elementType));
                    Array.set(array, i, value);
                }
                return array;
            }
            case MAP: {
                MapType mapType = (MapType)fieldType;
                SeaTunnelDataType keyType = mapType.getKeyType();
                SeaTunnelDataType valueType = mapType.getValueType();
                HashMap<Object, Object> objectMap = new HashMap<Object, Object>();
                int mapSize = this.fakeConfig.getMapSize();
                for (int i = 0; i < mapSize; ++i) {
                    Object key = this.randomColumnValue(column.copy(keyType));
                    Object value = this.randomColumnValue(column.copy(valueType));
                    objectMap.put(key, value);
                }
                return objectMap;
            }
            case STRING: {
                return FakeDataGenerator.value(column, String::toString, this.fakeDataRandomUtils::randomString);
            }
            case BOOLEAN: {
                return FakeDataGenerator.value(column, Boolean::parseBoolean, this.fakeDataRandomUtils::randomBoolean);
            }
            case TINYINT: {
                return FakeDataGenerator.value(column, Byte::parseByte, this.fakeDataRandomUtils::randomTinyint);
            }
            case SMALLINT: {
                return FakeDataGenerator.value(column, Short::parseShort, this.fakeDataRandomUtils::randomSmallint);
            }
            case INT: {
                return FakeDataGenerator.value(column, Integer::parseInt, this.fakeDataRandomUtils::randomInt);
            }
            case BIGINT: {
                return FakeDataGenerator.value(column, Long::parseLong, this.fakeDataRandomUtils::randomBigint);
            }
            case FLOAT: {
                return FakeDataGenerator.value(column, Float::parseFloat, this.fakeDataRandomUtils::randomFloat);
            }
            case DOUBLE: {
                return FakeDataGenerator.value(column, Double::parseDouble, this.fakeDataRandomUtils::randomDouble);
            }
            case DECIMAL: {
                return FakeDataGenerator.value(column, BigDecimal::new, this.fakeDataRandomUtils::randomBigDecimal);
            }
            case NULL: {
                return null;
            }
            case BYTES: {
                return FakeDataGenerator.value(column, String::getBytes, this.fakeDataRandomUtils::randomBytes);
            }
            case DATE: {
                return FakeDataGenerator.value(column, defaultValue -> {
                    if (defaultValue.equalsIgnoreCase(CURRENT_DATE)) {
                        return LocalDate.now();
                    }
                    DateTimeFormatter dateTimeFormatter = DateUtils.matchDateFormatter((String)defaultValue);
                    return LocalDate.parse(defaultValue, dateTimeFormatter == null ? DateTimeFormatter.ISO_LOCAL_DATE : dateTimeFormatter);
                }, this.fakeDataRandomUtils::randomLocalDate);
            }
            case TIME: {
                return FakeDataGenerator.value(column, defaultValue -> {
                    if (defaultValue.equalsIgnoreCase(CURRENT_TIME)) {
                        return LocalTime.now();
                    }
                    return LocalTime.parse(defaultValue, DateTimeFormatter.ISO_LOCAL_TIME);
                }, this.fakeDataRandomUtils::randomLocalTime);
            }
            case TIMESTAMP: {
                return FakeDataGenerator.value(column, defaultValue -> {
                    if (defaultValue.equalsIgnoreCase(CURRENT_TIMESTAMP)) {
                        return LocalDateTime.now();
                    }
                    DateTimeFormatter dateTimeFormatter = DateTimeUtils.matchDateTimeFormatter((String)defaultValue);
                    return LocalDateTime.parse(defaultValue, dateTimeFormatter == null ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : dateTimeFormatter);
                }, this.fakeDataRandomUtils::randomLocalDateTime);
            }
            case TIMESTAMP_TZ: {
                return FakeDataGenerator.value(column, defaultValue -> {
                    if (defaultValue.equalsIgnoreCase(CURRENT_TIMESTAMP)) {
                        return OffsetDateTime.now();
                    }
                    DateTimeFormatter dateTimeFormatter = DateTimeUtils.matchDateTimeFormatter((String)defaultValue);
                    return OffsetDateTime.parse(defaultValue, dateTimeFormatter == null ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : dateTimeFormatter);
                }, c -> this.fakeDataRandomUtils.randomLocalDateTime((Column)c).atZone(ZoneId.systemDefault()).toOffsetDateTime());
            }
            case ROW: {
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)fieldType).getFieldTypes();
                Object[] objects = new Object[fieldTypes.length];
                for (int i = 0; i < fieldTypes.length; ++i) {
                    Object object;
                    objects[i] = object = this.randomColumnValue(column.copy(fieldTypes[i]));
                }
                return new SeaTunnelRow(objects);
            }
            case BINARY_VECTOR: {
                return this.fakeDataRandomUtils.randomBinaryVector(column);
            }
            case FLOAT_VECTOR: {
                return this.fakeDataRandomUtils.randomFloatVector(column);
            }
            case FLOAT16_VECTOR: {
                return this.fakeDataRandomUtils.randomFloat16Vector(column);
            }
            case BFLOAT16_VECTOR: {
                return this.fakeDataRandomUtils.randomBFloat16Vector(column);
            }
            case SPARSE_FLOAT_VECTOR: {
                return this.fakeDataRandomUtils.randomSparseFloatVector(column);
            }
        }
        throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "SeaTunnel Fake source connector not support this data type");
    }

    private static <T> T value(Column column, Function<String, T> convert, Function<Column, T> generate) {
        if (column.getDefaultValue() != null) {
            return convert.apply(column.getDefaultValue().toString());
        }
        return generate.apply(column);
    }
}

