/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.client.api.LeaderElectionManagementApi;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.CallId;

public class LeaderElectionManagementImpl
implements LeaderElectionManagementApi {
    private final RaftClientImpl client;
    private final RaftPeerId server;

    LeaderElectionManagementImpl(RaftPeerId server, RaftClientImpl client) {
        this.server = Objects.requireNonNull(server, "server == null");
        this.client = Objects.requireNonNull(client, "client == null");
    }

    @Override
    public RaftClientReply pause() throws IOException {
        long callId = CallId.getAndIncrement();
        return this.client.io().sendRequestWithRetry(() -> LeaderElectionManagementRequest.newPause(this.client.getId(), this.server, this.client.getGroupId(), callId));
    }

    @Override
    public RaftClientReply resume() throws IOException {
        long callId = CallId.getAndIncrement();
        return this.client.io().sendRequestWithRetry(() -> LeaderElectionManagementRequest.newResume(this.client.getId(), this.server, this.client.getGroupId(), callId));
    }
}

