/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import java.util.Set;
import org.apache.ranger.authz.model.RangerResourceInfo;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerAccessInfo {
    private RangerResourceInfo resource;
    private String action;
    private Set<String> permissions;

    public RangerAccessInfo() {
    }

    public RangerAccessInfo(RangerResourceInfo resource, String action, Set<String> permissions) {
        this.resource = resource;
        this.action = action;
        this.permissions = permissions;
    }

    public RangerResourceInfo getResource() {
        return this.resource;
    }

    public void setResource(RangerResourceInfo resource) {
        this.resource = resource;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.action, this.permissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangerAccessInfo that = (RangerAccessInfo)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.action, that.action) && Objects.equals(this.permissions, that.permissions);
    }

    public String toString() {
        return "RangerAccessInfo{resource='" + this.resource + '\'' + ", action=" + this.action + ", permissions=" + this.permissions + '}';
    }
}

