/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;

public class RangerPolicyEngineOptions {
    public String evaluatorType = "auto";
    public boolean disableContextEnrichers = false;
    public boolean disableCustomConditions = false;
    public boolean disableTagPolicyEvaluation = false;
    public boolean disableTrieLookupPrefilter = false;
    public boolean disablePolicyRefresher = false;
    public boolean disableTagRetriever = false;
    public boolean disableUserStoreRetriever = false;
    public boolean cacheAuditResults = true;
    public boolean evaluateDelegateAdminOnly = false;
    public boolean enableTagEnricherWithLocalRefresher = false;
    public boolean enableUserStoreEnricherWithLocalRefresher = false;
    public boolean enableResourceMatcherReuse = true;
    @Deprecated
    public boolean disableAccessEvaluationWithPolicyACLSummary = true;
    public boolean optimizeTrieForRetrieval = false;
    public boolean disableRoleResolution = true;
    public boolean optimizeTrieForSpace = false;
    public boolean optimizeTagTrieForRetrieval = false;
    public boolean optimizeTagTrieForSpace = false;
    private RangerServiceDefHelper serviceDefHelper;

    public RangerPolicyEngineOptions() {
    }

    public RangerPolicyEngineOptions(RangerPolicyEngineOptions other) {
        this(other, null);
    }

    public RangerPolicyEngineOptions(RangerPolicyEngineOptions other, RangerServiceDefHelper serviceDefHelper) {
        this.disableContextEnrichers = other.disableContextEnrichers;
        this.disableCustomConditions = other.disableCustomConditions;
        this.disableTagPolicyEvaluation = other.disableTagPolicyEvaluation;
        this.disableTrieLookupPrefilter = other.disableTrieLookupPrefilter;
        this.disablePolicyRefresher = other.disablePolicyRefresher;
        this.disableTagRetriever = other.disableTagRetriever;
        this.disableUserStoreRetriever = other.disableUserStoreRetriever;
        this.cacheAuditResults = other.cacheAuditResults;
        this.evaluateDelegateAdminOnly = other.evaluateDelegateAdminOnly;
        this.enableTagEnricherWithLocalRefresher = other.enableTagEnricherWithLocalRefresher;
        this.enableUserStoreEnricherWithLocalRefresher = other.enableUserStoreEnricherWithLocalRefresher;
        this.enableResourceMatcherReuse = other.enableResourceMatcherReuse;
        this.optimizeTrieForRetrieval = other.optimizeTrieForRetrieval;
        this.disableRoleResolution = other.disableRoleResolution;
        this.serviceDefHelper = serviceDefHelper;
        this.optimizeTrieForSpace = other.optimizeTrieForSpace;
        this.optimizeTagTrieForRetrieval = other.optimizeTagTrieForRetrieval;
        this.optimizeTagTrieForSpace = other.optimizeTagTrieForSpace;
    }

    public void configureForPlugin(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", false);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", false);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", false);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", false);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", false);
        this.disableUserStoreRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.userstore.retriever", false);
        this.cacheAuditResults = conf.getBoolean(propertyPrefix + ".policyengine.option.cache.audit.results", true);
        this.enableResourceMatcherReuse = conf.getBoolean(propertyPrefix + ".policyengine.option.enable.resourcematcher.reuse", true);
        if (!this.disableTrieLookupPrefilter) {
            this.cacheAuditResults = false;
        }
        this.evaluateDelegateAdminOnly = false;
        this.enableTagEnricherWithLocalRefresher = false;
        this.enableUserStoreEnricherWithLocalRefresher = false;
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
        this.disableRoleResolution = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.role.resolution", true);
        this.optimizeTrieForSpace = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.space", false);
        this.optimizeTagTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.tag.trie.for.retrieval", false);
        this.optimizeTagTrieForSpace = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.tag.trie.for.space", false);
    }

    public void configureDefaultRangerAdmin(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", true);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", true);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", true);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", true);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", true);
        this.disableUserStoreRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.userstore.retriever", true);
        this.cacheAuditResults = false;
        this.evaluateDelegateAdminOnly = false;
        this.enableTagEnricherWithLocalRefresher = false;
        this.enableUserStoreEnricherWithLocalRefresher = false;
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
        this.disableRoleResolution = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.role.resolution", true);
        this.enableResourceMatcherReuse = conf.getBoolean(propertyPrefix + ".policyengine.option.enable.resourcematcher.reuse", true);
    }

    public void configureDelegateAdmin(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", true);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", true);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", true);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", true);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", true);
        this.disableUserStoreRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.userstore.retriever", true);
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
        this.enableResourceMatcherReuse = conf.getBoolean(propertyPrefix + ".policyengine.option.enable.resourcematcher.reuse", true);
        this.cacheAuditResults = false;
        this.evaluateDelegateAdminOnly = true;
        this.enableTagEnricherWithLocalRefresher = false;
        this.enableUserStoreEnricherWithLocalRefresher = false;
    }

    public void configureRangerAdminForPolicySearch(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", true);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", true);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", false);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", true);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", false);
        this.disableUserStoreRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.userstore.retriever", false);
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
        this.cacheAuditResults = false;
        this.evaluateDelegateAdminOnly = false;
        this.enableTagEnricherWithLocalRefresher = true;
        this.enableUserStoreEnricherWithLocalRefresher = true;
        this.optimizeTrieForSpace = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.space", false);
        this.optimizeTagTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.tag.trie.for.retrieval", false);
        this.optimizeTagTrieForSpace = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.tag.trie.for.space", true);
        this.enableResourceMatcherReuse = conf.getBoolean(propertyPrefix + ".policyengine.option.enable.resourcematcher.reuse", true);
    }

    public RangerServiceDefHelper getServiceDefHelper() {
        return this.serviceDefHelper;
    }

    void setServiceDefHelper(RangerServiceDefHelper serviceDefHelper) {
        this.serviceDefHelper = serviceDefHelper;
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (other instanceof RangerPolicyEngineOptions) {
            RangerPolicyEngineOptions that = (RangerPolicyEngineOptions)other;
            ret = this.disableContextEnrichers == that.disableContextEnrichers && this.disableCustomConditions == that.disableCustomConditions && this.disableTagPolicyEvaluation == that.disableTagPolicyEvaluation && this.disableTrieLookupPrefilter == that.disableTrieLookupPrefilter && this.disablePolicyRefresher == that.disablePolicyRefresher && this.disableTagRetriever == that.disableTagRetriever && this.disableUserStoreRetriever == that.disableUserStoreRetriever && this.cacheAuditResults == that.cacheAuditResults && this.evaluateDelegateAdminOnly == that.evaluateDelegateAdminOnly && this.enableTagEnricherWithLocalRefresher == that.enableTagEnricherWithLocalRefresher && this.enableUserStoreEnricherWithLocalRefresher == that.enableUserStoreEnricherWithLocalRefresher && this.optimizeTrieForRetrieval == that.optimizeTrieForRetrieval && this.disableRoleResolution == that.disableRoleResolution && this.optimizeTrieForSpace == that.optimizeTrieForSpace && this.optimizeTagTrieForRetrieval == that.optimizeTagTrieForRetrieval && this.optimizeTagTrieForSpace == that.optimizeTagTrieForSpace && this.enableResourceMatcherReuse == that.enableResourceMatcherReuse;
        }
        return ret;
    }

    public int hashCode() {
        int ret = 0;
        ret += this.disableContextEnrichers ? 1 : 0;
        ret *= 2;
        ret += this.disableCustomConditions ? 1 : 0;
        ret *= 2;
        ret += this.disableTagPolicyEvaluation ? 1 : 0;
        ret *= 2;
        ret += this.disableTrieLookupPrefilter ? 1 : 0;
        ret *= 2;
        ret += this.disablePolicyRefresher ? 1 : 0;
        ret *= 2;
        ret += this.disableTagRetriever ? 1 : 0;
        ret *= 2;
        ret += this.disableUserStoreRetriever ? 1 : 0;
        ret *= 2;
        ret += this.cacheAuditResults ? 1 : 0;
        ret *= 2;
        ret += this.evaluateDelegateAdminOnly ? 1 : 0;
        ret *= 2;
        ret += this.enableTagEnricherWithLocalRefresher ? 1 : 0;
        ret *= 2;
        ret += this.enableUserStoreEnricherWithLocalRefresher ? 1 : 0;
        ret *= 2;
        ret += this.optimizeTrieForRetrieval ? 1 : 0;
        ret *= 2;
        ret += this.disableRoleResolution ? 1 : 0;
        ret *= 2;
        ret += this.optimizeTrieForSpace ? 1 : 0;
        ret *= 2;
        ret += this.optimizeTagTrieForRetrieval ? 1 : 0;
        ret *= 2;
        ret += this.optimizeTagTrieForSpace ? 1 : 0;
        ret *= 2;
        ret += this.enableResourceMatcherReuse ? 1 : 0;
        return ret *= 2;
    }

    public String toString() {
        return "PolicyEngineOptions: { evaluatorType: " + this.evaluatorType + ", evaluateDelegateAdminOnly: " + this.evaluateDelegateAdminOnly + ", disableContextEnrichers: " + this.disableContextEnrichers + ", disableCustomConditions: " + this.disableContextEnrichers + ", disableTagPolicyEvaluation: " + this.disableTagPolicyEvaluation + ", disablePolicyRefresher: " + this.disablePolicyRefresher + ", disableTagRetriever: " + this.disableTagRetriever + ", disableUserStoreRetriever: " + this.disableUserStoreRetriever + ", enableTagEnricherWithLocalRefresher: " + this.enableTagEnricherWithLocalRefresher + ", enableUserStoreEnricherWithLocalRefresher: " + this.enableUserStoreEnricherWithLocalRefresher + ", disableTrieLookupPrefilter: " + this.disableTrieLookupPrefilter + ", optimizeTrieForRetrieval: " + this.optimizeTrieForRetrieval + ", cacheAuditResult: " + this.cacheAuditResults + ", disableRoleResolution: " + this.disableRoleResolution + ", optimizeTrieForSpace: " + this.optimizeTrieForSpace + ", optimizeTagTrieForRetrieval: " + this.optimizeTagTrieForRetrieval + ", optimizeTagTrieForSpace: " + this.optimizeTagTrieForSpace + ", enableResourceMatcherReuse: " + this.enableResourceMatcherReuse + " }";
    }
}

