/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class SecurityZonePredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        this.addPredicateForServiceName(filter.getParam("serviceName"), predicates);
        this.addPredicateForMatchingZoneId(filter.getParam("zoneId"), predicates);
        this.addPredicateForMatchingZoneName(filter.getParam("zoneName"), predicates);
        this.addPredicateForNonMatchingZoneName(filter.getParam("notZoneName"), predicates);
        this.addPredicateForMatchingZoneNamePartial(filter.getParam("zoneNamePartial"), predicates);
        this.addPredicateForCreatedBy(filter.getParam("createdBy"), predicates);
    }

    private Predicate addPredicateForServiceName(final String serviceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerSecurityZone) {
                    RangerSecurityZone securityZone = (RangerSecurityZone)object;
                    ret = securityZone.getServices().get(serviceName) != null;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForMatchingZoneId(final String zoneId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)zoneId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                RangerSecurityZone securityZone;
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerSecurityZone && StringUtils.equals((CharSequence)zoneId, (CharSequence)(securityZone = (RangerSecurityZone)object).getId().toString())) {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForMatchingZoneName(final String zoneName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)zoneName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                RangerSecurityZone securityZone;
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerSecurityZone && StringUtils.equals((CharSequence)zoneName, (CharSequence)(securityZone = (RangerSecurityZone)object).getName())) {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForNonMatchingZoneName(final String zoneName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)zoneName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                RangerSecurityZone securityZone;
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerSecurityZone && !StringUtils.equals((CharSequence)zoneName, (CharSequence)(securityZone = (RangerSecurityZone)object).getName())) {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForMatchingZoneNamePartial(final String zoneName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)zoneName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                RangerSecurityZone securityZone;
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerSecurityZone && StringUtils.containsIgnoreCase((CharSequence)(securityZone = (RangerSecurityZone)object).getName(), (CharSequence)zoneName)) {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForCreatedBy(final String createdBy, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)createdBy)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                RangerSecurityZone securityZone;
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerSecurityZone && StringUtils.equals((CharSequence)(securityZone = (RangerSecurityZone)object).getCreatedBy(), (CharSequence)createdBy)) {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

