/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.kms.client.KMSResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceKMS
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceKMS.class);
    public static final String ACCESS_TYPE_DECRYPT_EEK = "decrypteek";
    public static final String ACCESS_TYPE_GENERATE_EEK = "generateeek";
    public static final String ACCESS_TYPE_GET_METADATA = "getmetadata";
    public static final String ACCESS_TYPE_GET = "get";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceKMS.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = KMSResourceMgr.validateConfig(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceKMS.validateConfig Error:" + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceKMS.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceKMS.lookupResource Context: (" + context + ")");
        }
        if (context != null) {
            try {
                ret = KMSResourceMgr.getKMSResources(serviceName, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceKMS.lookupResource Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceKMS.lookupResource Response: (" + ret + ")");
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceKMS.getDefaultRangerPolicies() ");
        }
        List ret = super.getDefaultRangerPolicies();
        String adminPrincipal = this.getConfig().get("ranger.admin.kerberos.principal");
        String adminKeytab = this.getConfig().get("ranger.admin.kerberos.keytab");
        String authType = this.getConfig().get("hadoop.security.authentication", "simple");
        String adminUser = this.getLookupUser(authType, adminPrincipal, adminKeytab);
        ArrayList<RangerServiceDef.RangerAccessTypeDef> hdfsAccessTypeDefs = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        ArrayList<RangerServiceDef.RangerAccessTypeDef> omAccessTypeDefs = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        ArrayList<RangerServiceDef.RangerAccessTypeDef> hiveAccessTypeDefs = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        ArrayList<RangerServiceDef.RangerAccessTypeDef> hbaseAccessTypeDefs = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : this.serviceDef.getAccessTypes()) {
            if (accessTypeDef.getName().equalsIgnoreCase(ACCESS_TYPE_GET_METADATA)) {
                hdfsAccessTypeDefs.add(accessTypeDef);
                omAccessTypeDefs.add(accessTypeDef);
                hiveAccessTypeDefs.add(accessTypeDef);
                continue;
            }
            if (accessTypeDef.getName().equalsIgnoreCase(ACCESS_TYPE_GENERATE_EEK)) {
                hdfsAccessTypeDefs.add(accessTypeDef);
                omAccessTypeDefs.add(accessTypeDef);
                continue;
            }
            if (!accessTypeDef.getName().equalsIgnoreCase(ACCESS_TYPE_DECRYPT_EEK)) continue;
            hiveAccessTypeDefs.add(accessTypeDef);
            hbaseAccessTypeDefs.add(accessTypeDef);
        }
        for (RangerPolicy defaultPolicy : ret) {
            String hbaseUser;
            String hiveUser;
            String omUser;
            if (defaultPolicy.getName().contains("all") && StringUtils.isNotBlank((CharSequence)this.lookUpUser)) {
                RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
                policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
                policyItemForLookupUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_GET)));
                policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
                defaultPolicy.addPolicyItem(policyItemForLookupUser);
            }
            for (RangerPolicy.RangerPolicyItem item : defaultPolicy.getPolicyItems()) {
                if (!StringUtils.isNotBlank((CharSequence)adminUser)) continue;
                item.addUser(adminUser);
            }
            String hdfsUser = this.getConfig().get("ranger.kms.service.user.hdfs", "hdfs");
            if (hdfsUser != null && !hdfsUser.isEmpty()) {
                LOG.info("Creating default KMS policy item for " + hdfsUser);
                ArrayList<String> users = new ArrayList<String>();
                users.add(hdfsUser);
                RangerPolicy.RangerPolicyItem policyItem = this.createDefaultPolicyItem(hdfsAccessTypeDefs, users);
                defaultPolicy.addPolicyItem(policyItem);
            }
            if (StringUtils.isNotEmpty((CharSequence)(omUser = this.getConfig().get("ranger.kms.service.user.om", "om")))) {
                LOG.info("Creating default KMS policy item for " + omUser);
                ArrayList<String> users = new ArrayList<String>();
                users.add(omUser);
                RangerPolicy.RangerPolicyItem policyItem = this.createDefaultPolicyItem(omAccessTypeDefs, users);
                defaultPolicy.addPolicyItem(policyItem);
            }
            if ((hiveUser = this.getConfig().get("ranger.kms.service.user.hive", "hive")) != null && !hiveUser.isEmpty()) {
                LOG.info("Creating default KMS policy item for " + hiveUser);
                ArrayList<String> users = new ArrayList<String>();
                users.add(hiveUser);
                RangerPolicy.RangerPolicyItem policyItem = this.createDefaultPolicyItem(hiveAccessTypeDefs, users);
                defaultPolicy.addPolicyItem(policyItem);
            }
            if ((hbaseUser = this.getConfig().get("ranger.kms.service.user.hbase", "hbase")) == null || hbaseUser.isEmpty()) continue;
            LOG.info("Creating default KMS policy item for " + hbaseUser);
            ArrayList<String> users = new ArrayList<String>();
            users.add(hbaseUser);
            RangerPolicy.RangerPolicyItem policyItem = this.createDefaultPolicyItem(hbaseAccessTypeDefs, users);
            defaultPolicy.addPolicyItem(policyItem);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceKMS.getDefaultRangerPolicies() : " + ret);
        }
        return ret;
    }

    private RangerPolicy.RangerPolicyItem createDefaultPolicyItem(List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs, List<String> users) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTag.createDefaultPolicyItem()");
        }
        RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
        policyItem.setUsers(users);
        ArrayList<RangerPolicy.RangerPolicyItemAccess> accesses = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
            RangerPolicy.RangerPolicyItemAccess access = new RangerPolicy.RangerPolicyItemAccess();
            access.setType(accessTypeDef.getName());
            access.setIsAllowed(Boolean.valueOf(true));
            accesses.add(access);
        }
        policyItem.setAccesses(accesses);
        policyItem.setDelegateAdmin(Boolean.valueOf(true));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTag.createDefaultPolicyItem(): " + policyItem);
        }
        return policyItem;
    }
}

