/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.kms.dao;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.ranger.kms.dao.DaoManager;
import org.apache.ranger.kms.dao.DaoManagerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDao<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseDao.class);
    protected final DaoManager daoManager;
    protected final Class<T> tClass;

    protected BaseDao(DaoManagerBase daoManager) {
        this.daoManager = (DaoManager)daoManager;
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type type = genericSuperclass.getActualTypeArguments()[0];
        this.tClass = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
    }

    public EntityManager getEntityManager() {
        return this.daoManager.getEntityManager();
    }

    public boolean beginTransaction() {
        EntityTransaction et;
        boolean ret = false;
        EntityManager em = this.getEntityManager();
        if (em != null && (et = em.getTransaction()) != null && !et.isActive()) {
            et.begin();
            ret = true;
        }
        return ret;
    }

    public void commitTransaction() {
        EntityManager em = this.getEntityManager();
        if (em != null) {
            em.flush();
            EntityTransaction et = em.getTransaction();
            if (et != null) {
                et.commit();
            }
        }
    }

    public void rollbackTransaction() {
        EntityTransaction et;
        EntityManager em = this.getEntityManager();
        if (em != null && (et = em.getTransaction()) != null) {
            et.rollback();
        }
    }

    public T create(T obj) {
        T ret = null;
        boolean trxBegan = this.beginTransaction();
        try {
            this.getEntityManager().persist(obj);
            if (trxBegan) {
                this.commitTransaction();
            }
            ret = obj;
        }
        catch (Exception e) {
            logger.error("create({}) failed", (Object)this.tClass.getSimpleName(), (Object)e);
            this.rollbackTransaction();
            throw e;
        }
        return ret;
    }

    public T update(T obj) {
        boolean trxBegan = this.beginTransaction();
        this.getEntityManager().merge(obj);
        if (trxBegan) {
            this.commitTransaction();
        }
        return obj;
    }

    public boolean remove(Long id) {
        return this.remove(this.getById(id));
    }

    public boolean remove(T obj) {
        if (obj == null) {
            return true;
        }
        boolean trxBegan = this.beginTransaction();
        this.getEntityManager().remove(obj);
        if (trxBegan) {
            this.commitTransaction();
        }
        return true;
    }

    public T getById(Long id) {
        Object ret;
        if (id == null) {
            return null;
        }
        try {
            ret = this.getEntityManager().find(this.tClass, (Object)id);
        }
        catch (NoResultException e) {
            return null;
        }
        return (T)ret;
    }

    public List<T> getAll() {
        TypedQuery qry = this.getEntityManager().createQuery("SELECT t FROM " + this.tClass.getSimpleName() + " t", this.tClass);
        qry.setHint("eclipselink.refresh", (Object)"true");
        List ret = qry.getResultList();
        return ret;
    }

    public Long getAllCount() {
        TypedQuery qry = this.getEntityManager().createQuery("SELECT count(t) FROM " + this.tClass.getSimpleName() + " t", Long.class);
        qry.setHint("eclipselink.refresh", (Object)"true");
        Long ret = (Long)qry.getSingleResult();
        return ret;
    }

    public T getUniqueResult(TypedQuery<T> qry) {
        Object ret = null;
        try {
            ret = qry.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return (T)ret;
    }

    public List<T> executeQuery(TypedQuery<T> qry) {
        List ret = qry.getResultList();
        return ret;
    }

    public List<T> findByNamedQuery(String namedQuery, String paramName, Object refId) {
        List ret = new ArrayList();
        if (namedQuery != null) {
            try {
                TypedQuery qry = this.getEntityManager().createNamedQuery(namedQuery, this.tClass);
                qry.setParameter(paramName, refId);
                ret = qry.getResultList();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        return ret;
    }

    public T findByAlias(String namedQuery, String alias) {
        try {
            return (T)this.getEntityManager().createNamedQuery(namedQuery, this.tClass).setParameter("alias", (Object)alias).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public int deleteByAlias(String namedQuery, String alias) {
        int ret = 0;
        boolean trxBegan = this.beginTransaction();
        try {
            ret = this.getEntityManager().createNamedQuery(namedQuery, this.tClass).setParameter("alias", (Object)alias).executeUpdate();
            if (trxBegan) {
                this.commitTransaction();
            }
        }
        catch (NoResultException e) {
            logger.error("deleteByAlias({}) failed", (Object)alias, (Object)e);
            this.rollbackTransaction();
        }
        return ret;
    }
}

