/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerMultiResourceAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

public class RangerSolrAuditHandler
extends RangerMultiResourceAuditHandler {
    private static final String PROP_SOLR_PLUGIN_AUDIT_EXCLUDED_USERS = "ranger.solr.plugin.audit.excluded.users";
    private static final String RANGER_AUDIT_COLLECTION = "ranger_audits";
    private String solrUser = "solr";
    private List<String> excludeUsers = null;
    private AuthzAuditEvent auditEvent = null;

    public RangerSolrAuditHandler(Configuration config) {
        String excludeUserList = config.get(PROP_SOLR_PLUGIN_AUDIT_EXCLUDED_USERS, this.solrUser);
        this.excludeUsers = Arrays.asList(excludeUserList.split(","));
    }

    public void processResult(RangerAccessResult result) {
        if (!this.isAuditingNeeded(result)) {
            return;
        }
        this.auditEvent = super.getAuthzEvents(result);
        if (this.auditEvent != null) {
            super.logAuthzAudit(this.auditEvent);
        }
    }

    private boolean isAuditingNeeded(RangerAccessResult result) {
        boolean ret = true;
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResourceImpl resource = (RangerAccessResourceImpl)request.getResource();
        String resourceName = (String)resource.getValue("collection");
        String requestUser = request.getUser();
        if (resourceName != null && resourceName.equals(RANGER_AUDIT_COLLECTION) && this.excludeUsers.contains(requestUser)) {
            ret = false;
        }
        return ret;
    }
}

