/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.routing;

import org.apache.solr.client.solrj.routing.AffinityReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformerFactory;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class AffinityReplicaListTransformerFactory
implements ReplicaListTransformerFactory {
    private final String defaultDividendParam;
    private final String defaultHashParam;

    public AffinityReplicaListTransformerFactory() {
        this.defaultDividendParam = null;
        this.defaultHashParam = "q";
    }

    public AffinityReplicaListTransformerFactory(String defaultDividendParam, String defaultHashParam) {
        this.defaultDividendParam = defaultDividendParam;
        this.defaultHashParam = defaultHashParam;
    }

    public AffinityReplicaListTransformerFactory(NamedList<?> c) {
        this((String)c.get("dividend"), AffinityReplicaListTransformerFactory.translateHashParam((String)c.get("hash")));
    }

    private static String translateHashParam(String hashParam) {
        if (hashParam == null) {
            return "q";
        }
        if (hashParam.isEmpty()) {
            return null;
        }
        return hashParam;
    }

    @Override
    public ReplicaListTransformer getInstance(String configSpec, SolrParams requestParams, ReplicaListTransformerFactory fallback) {
        ReplicaListTransformer rlt;
        if (configSpec == null) {
            rlt = AffinityReplicaListTransformer.getInstance(this.defaultDividendParam, this.defaultHashParam, requestParams);
        } else {
            String[] parts = configSpec.split(":", 2);
            switch (parts[0]) {
                case "dividend": {
                    rlt = AffinityReplicaListTransformer.getInstance(parts.length == 1 ? this.defaultDividendParam : parts[1], this.defaultHashParam, requestParams);
                    break;
                }
                case "hash": {
                    rlt = AffinityReplicaListTransformer.getInstance(null, parts.length == 1 ? this.defaultHashParam : parts[1], requestParams);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid routing spec: \"" + configSpec + '\"');
                }
            }
        }
        return rlt != null ? rlt : fallback.getInstance(null, requestParams, null);
    }
}

