/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.resourcematcher.RecursiveMatcher;

final class CaseInsensitiveURLRecursiveMatcher
extends RecursiveMatcher {
    CaseInsensitiveURLRecursiveMatcher(String value, Map<String, String> options, char levelSeparatorChar) {
        super(value, options, levelSeparatorChar);
    }

    @Override
    boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
        String expandedPolicyValue;
        String noSeparator = this.getNeedsDynamicEval() ? ((expandedPolicyValue = this.getExpandedValue(evalContext)) != null ? this.getStringToCompare(expandedPolicyValue) : null) : this.valueWithoutSeparator;
        boolean ret = StringUtils.equalsIgnoreCase((CharSequence)resourceValue, (CharSequence)noSeparator);
        if (!ret && noSeparator != null) {
            String withSeparator = this.getNeedsDynamicEval() ? noSeparator + Character.toString(this.levelSeparatorChar) : this.valueWithSeparator;
            ret = StringUtils.startsWithIgnoreCase((CharSequence)resourceValue, (CharSequence)withSeparator);
        }
        return ret;
    }

    @Override
    public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.getExpandedValue(evalContext), (CharSequence)resourceValue);
    }

    @Override
    int getPriority() {
        return 8 + (this.getNeedsDynamicEval() ? 8 : 0);
    }
}

