/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authz.api.RangerAuthzApiErrorCode;
import org.apache.ranger.authz.api.RangerAuthzErrorCode;
import org.apache.ranger.authz.api.RangerAuthzException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerResourceNameParser {
    private static final Logger LOG = LoggerFactory.getLogger(RangerResourceNameParser.class);
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final char RRN_RESOURCE_TYPE_SEP = ':';
    public static final char DEFAULT_RRN_RESOURCE_SEP = '/';
    private static final char ESCAPE_CHAR = '\\';
    private static final String ESCAPE_STRING = "\\\\";
    private final char separatorChar;
    private final String separatorString;
    private final String escapedSeparator;
    private final Pattern separatorPattern;
    private final String template;
    private final String[] resources;

    public RangerResourceNameParser(String[] resourcePath) throws RangerAuthzException {
        this(resourcePath, '/');
    }

    public RangerResourceNameParser(String[] resourcePath, char separatorChar) throws RangerAuthzException {
        if (resourcePath == null || resourcePath.length == 0) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_RESOURCE_TEMPLATE_EMPTY_VALUE);
        }
        this.separatorChar = separatorChar;
        this.separatorString = String.valueOf(separatorChar);
        this.escapedSeparator = ESCAPE_STRING + this.separatorString;
        this.separatorPattern = Pattern.compile(this.separatorString);
        this.template = StringUtils.join((Object[])resourcePath, (char)separatorChar);
        this.resources = resourcePath;
    }

    public RangerResourceNameParser(String template) throws RangerAuthzException {
        this(template, '/');
    }

    public RangerResourceNameParser(String template, char separatorChar) throws RangerAuthzException {
        if (StringUtils.isBlank((CharSequence)template)) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_RESOURCE_TEMPLATE_EMPTY_VALUE);
        }
        this.separatorChar = separatorChar;
        this.separatorString = String.valueOf(separatorChar);
        this.escapedSeparator = ESCAPE_STRING + this.separatorString;
        this.separatorPattern = Pattern.compile(this.separatorString);
        this.template = template;
        this.resources = template.split(this.separatorString);
    }

    public String getTemplate() {
        return this.template;
    }

    public String getResourceType() {
        return this.resources[this.resources.length - 1];
    }

    public int count() {
        return this.resources.length;
    }

    public String resourceAt(int index) {
        return this.resources[index];
    }

    public String[] parseToArray(String resourceName) throws RangerAuthzException {
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_RESOURCE_EMPTY_VALUE);
        }
        String[] ret = new String[this.resources.length];
        int nameLen = resourceName.length();
        StringBuilder token = new StringBuilder();
        int idxToken = 0;
        boolean isLastToken = this.resources.length == 1;
        boolean isInEscape = false;
        for (int i = 0; i < nameLen; ++i) {
            char c = resourceName.charAt(i);
            if (c == '\\') {
                if (!isInEscape) {
                    isInEscape = true;
                    continue;
                }
            } else if (c == this.separatorChar && !isInEscape && !isLastToken) {
                ret[idxToken++] = token.toString();
                token.setLength(0);
                isLastToken = idxToken == this.resources.length - 1;
                continue;
            }
            token.append(c);
            isInEscape = false;
        }
        ret[idxToken] = token.toString();
        if (!isLastToken) {
            throw new RangerAuthzException((RangerAuthzErrorCode)RangerAuthzApiErrorCode.INVALID_RESOURCE_VALUE, resourceName, this.template);
        }
        LOG.debug("parseToArray(resource='{}', template='{}'): ret={}", new Object[]{resourceName, this.template, ret});
        return ret;
    }

    public Map<String, String> parseToMap(String resourceName) throws RangerAuthzException {
        String[] arr = this.parseToArray(resourceName);
        HashMap<String, String> ret = new HashMap<String, String>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            ret.put(this.resources[i], arr[i]);
        }
        LOG.debug("parseToMap(resourceName='{}', template='{}'): ret={}", new Object[]{resourceName, this.template, ret});
        return ret;
    }

    public String toResourceName(String[] values) {
        StringBuilder ret = new StringBuilder();
        if (values == null) {
            values = EMPTY_ARRAY;
        }
        for (int i = 0; i < this.resources.length; ++i) {
            boolean isLast;
            String value = values.length > i ? values[i] : null;
            boolean bl = isLast = i == this.resources.length - 1;
            if (value == null) {
                value = "";
            }
            if (!isLast) {
                value = this.escapeIfNeeded(value);
            }
            if (i > 0) {
                ret.append(this.separatorChar);
            }
            ret.append(value);
        }
        LOG.debug("toResourceName(values={}, template='{}'): ret='{}'", new Object[]{values, this.template, ret});
        return ret.toString();
    }

    public String toResourceName(Map<String, String> values) {
        StringBuilder ret = new StringBuilder();
        if (values == null) {
            values = Collections.emptyMap();
        }
        for (int i = 0; i < this.resources.length; ++i) {
            boolean isLast;
            String value = values.get(this.resources[i]);
            boolean bl = isLast = i == this.resources.length - 1;
            if (value == null) {
                value = "";
            }
            if (!isLast) {
                value = this.escapeIfNeeded(value);
            }
            if (i > 0) {
                ret.append(this.separatorChar);
            }
            ret.append(value);
        }
        LOG.debug("toResourceName(values={}, template='{}'): ret='{}'", new Object[]{values, this.template, ret});
        return ret.toString();
    }

    public String toString() {
        return "RangerResourceTemplate{template=" + this.template + ", resources='" + String.join((CharSequence)this.separatorString, this.resources) + "'}";
    }

    private String escapeIfNeeded(String value) {
        if (value.contains(this.separatorString)) {
            return this.separatorPattern.matcher(value).replaceAll(this.escapedSeparator);
        }
        return value;
    }
}

