/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyresourcematcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultPolicyResourceMatcher
implements RangerPolicyResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultPolicyResourceMatcher.class);
    private static final Logger PERF_POLICY_RESOURCE_MATCHER_INIT_LOG = RangerPerfTracer.getPerfLogger("policyresourcematcher.init");
    private static final Logger PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG = RangerPerfTracer.getPerfLogger("policyresourcematcher.match");
    protected RangerServiceDef serviceDef;
    protected int policyType;
    protected Map<String, RangerPolicy.RangerPolicyResource> policyResources;
    private Map<String, RangerResourceMatcher> allMatchers;
    private boolean needsDynamicEval = false;
    private List<RangerServiceDef.RangerResourceDef> validResourceHierarchy;
    private boolean isInitialized = false;
    private RangerServiceDefHelper serviceDefHelper;
    private RangerPluginContext pluginContext = null;
    private final boolean forceEnableWildcardMatch;

    public RangerDefaultPolicyResourceMatcher() {
        this.forceEnableWildcardMatch = false;
    }

    public RangerDefaultPolicyResourceMatcher(boolean forceEnableWildcardMatch) {
        this.forceEnableWildcardMatch = forceEnableWildcardMatch;
    }

    @Override
    public void setServiceDef(RangerServiceDef serviceDef) {
        if (this.isInitialized) {
            LOG.warn("RangerDefaultPolicyResourceMatcher is already initialized. init() must be done again after updating serviceDef");
        }
        this.serviceDef = serviceDef;
    }

    @Override
    public void setPolicy(RangerPolicy policy) {
        if (this.isInitialized) {
            LOG.warn("RangerDefaultPolicyResourceMatcher is already initialized. init() must be done again after updating policy");
        }
        if (policy == null) {
            this.setPolicyResources(null, 0);
        } else {
            this.setPolicyResources(policy.getResources(), policy.getPolicyType() == null ? 0 : policy.getPolicyType());
        }
    }

    @Override
    public void setPolicyResources(Map<String, RangerPolicy.RangerPolicyResource> policyResources) {
        if (this.isInitialized) {
            LOG.warn("RangerDefaultPolicyResourceMatcher is already initialized. init() must be done again after updating policy-resources");
        }
        this.setPolicyResources(policyResources, 0);
    }

    @Override
    public void setPolicyResources(Map<String, RangerPolicy.RangerPolicyResource> policyResources, int policyType) {
        this.policyResources = policyResources;
        this.policyType = policyType;
    }

    @Override
    public void setServiceDefHelper(RangerServiceDefHelper serviceDefHelper) {
        this.serviceDefHelper = serviceDefHelper;
    }

    @Override
    public void setPluginContext(RangerPluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public int getPolicyType() {
        return this.policyType;
    }

    public RangerServiceDefHelper getServiceDefHelper() {
        return this.serviceDefHelper;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public RangerResourceMatcher getResourceMatcher(String resourceName) {
        return this.allMatchers != null ? this.allMatchers.get(resourceName) : null;
    }

    @Override
    public boolean getNeedsDynamicEval() {
        return this.needsDynamicEval;
    }

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyResourceMatcher.init()");
        }
        this.allMatchers = null;
        this.needsDynamicEval = false;
        this.validResourceHierarchy = null;
        this.isInitialized = false;
        String errorText = "";
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_RESOURCE_MATCHER_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_RESOURCE_MATCHER_INIT_LOG, "RangerDefaultPolicyResourceMatcher.init()");
        }
        if (this.policyResources != null && !this.policyResources.isEmpty() && this.serviceDef != null) {
            this.serviceDefHelper = this.serviceDefHelper == null ? new RangerServiceDefHelper(this.serviceDef, false) : this.serviceDefHelper;
            Set<List<RangerServiceDef.RangerResourceDef>> resourceHierarchies = this.serviceDefHelper.getResourceHierarchies(this.policyType, this.policyResources.keySet());
            int validHierarchiesCount = 0;
            for (List<RangerServiceDef.RangerResourceDef> resourceHierarchy : resourceHierarchies) {
                if (RangerDefaultPolicyResourceMatcher.isHierarchyValidForResources(resourceHierarchy, this.policyResources)) {
                    if (++validHierarchiesCount == 1) {
                        this.validResourceHierarchy = resourceHierarchy;
                        continue;
                    }
                    this.validResourceHierarchy = null;
                    continue;
                }
                LOG.warn("RangerDefaultPolicyResourceMatcher.init(): gaps found in policyResources, skipping hierarchy:[" + resourceHierarchies + "]");
            }
            if (validHierarchiesCount > 0) {
                this.allMatchers = new HashMap<String, RangerResourceMatcher>();
                for (List<RangerServiceDef.RangerResourceDef> resourceHierarchy : resourceHierarchies) {
                    for (RangerServiceDef.RangerResourceDef resourceDef : resourceHierarchy) {
                        String resourceName = resourceDef.getName();
                        if (this.allMatchers.containsKey(resourceName)) continue;
                        RangerPolicy.RangerPolicyResource policyResource = this.policyResources.get(resourceName);
                        if (policyResource == null) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("RangerDefaultPolicyResourceMatcher.init(): no matcher created for " + resourceName + ". Continuing ...");
                            continue;
                        }
                        RangerResourceMatcher matcher = this.createResourceMatcher(resourceDef, policyResource);
                        if (matcher != null) {
                            if (!this.needsDynamicEval && matcher.getNeedsDynamicEval()) {
                                this.needsDynamicEval = true;
                            }
                            this.allMatchers.put(resourceName, matcher);
                            continue;
                        }
                        LOG.error("RangerDefaultPolicyResourceMatcher.init(): failed to find matcher for resource " + resourceName);
                        this.allMatchers = null;
                        errorText = "no matcher found for resource " + resourceName;
                        break;
                    }
                    if (this.allMatchers != null) continue;
                    break;
                }
            } else {
                errorText = "policyResources elements are not part of any valid resourcedef hierarchy.";
            }
        } else {
            errorText = "policyResources is null or empty, or serviceDef is null.";
        }
        if (this.allMatchers == null && this.policyType != 3) {
            this.serviceDefHelper = null;
            this.validResourceHierarchy = null;
            Set<String> policyResourceKeys = this.policyResources == null ? null : this.policyResources.keySet();
            String serviceDefName = this.serviceDef == null ? "" : this.serviceDef.getName();
            StringBuilder keysString = new StringBuilder();
            if (CollectionUtils.isNotEmpty(policyResourceKeys)) {
                for (String policyResourceKeyName : policyResourceKeys) {
                    keysString.append(policyResourceKeyName).append(" ");
                }
            }
            LOG.error("RangerDefaultPolicyResourceMatcher.init() failed: " + errorText + " (serviceDef=" + serviceDefName + ", policyResourceKeys=" + keysString.toString());
        } else {
            this.isInitialized = true;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyResourceMatcher.init(): ret=" + this.isInitialized);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return this.toString(sb).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultPolicyResourceMatcher={");
        sb.append("isInitialized=").append(this.isInitialized).append(", ");
        sb.append("matchers={");
        if (this.allMatchers != null) {
            for (RangerResourceMatcher matcher : this.allMatchers.values()) {
                sb.append("{").append(matcher).append("} ");
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    @Override
    public boolean isCompleteMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        boolean keysMatch;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resource + ", " + evalContext + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG, "RangerDefaultPolicyResourceMatcher.grantRevokeMatch()");
        }
        boolean ret = false;
        Set<String> resourceKeys = resource == null ? null : resource.getKeys();
        Set<String> policyKeys = this.policyResources == null ? null : this.policyResources.keySet();
        boolean bl = keysMatch = resourceKeys != null && policyKeys != null && CollectionUtils.isEqualCollection(resourceKeys, policyKeys);
        if (keysMatch) {
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                String strValue;
                String resourceName = resourceDef.getName();
                Object resourceValue = resource.getValue(resourceName);
                RangerResourceMatcher matcher = this.getResourceMatcher(resourceName);
                ret = resourceValue == null ? matcher == null || matcher.isCompleteMatch(null, evalContext) : (resourceValue instanceof String ? (StringUtils.isEmpty((CharSequence)(strValue = (String)resourceValue)) ? matcher == null || matcher.isCompleteMatch(strValue, evalContext) : matcher != null && matcher.isCompleteMatch(strValue, evalContext)) : false);
                if (ret) continue;
                break;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("isCompleteMatch(): keysMatch=false. resourceKeys=" + resourceKeys + "; policyKeys=" + policyKeys);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resource + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isCompleteMatch(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        boolean keysMatch;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resources + ", " + evalContext + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG, "RangerDefaultPolicyResourceMatcher.applyPolicyMatch()");
        }
        boolean ret = false;
        Set<String> resourceKeys = resources == null ? null : resources.keySet();
        Set<String> policyKeys = this.policyResources == null ? null : this.policyResources.keySet();
        boolean bl = keysMatch = resourceKeys != null && policyKeys != null && CollectionUtils.isEqualCollection(resourceKeys, policyKeys);
        if (keysMatch) {
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                RangerPolicy.RangerPolicyResource policyValues;
                String resourceName = resourceDef.getName();
                RangerPolicy.RangerPolicyResource resourceValues = resources.get(resourceName);
                RangerPolicy.RangerPolicyResource rangerPolicyResource = policyValues = this.policyResources == null ? null : this.policyResources.get(resourceName);
                if (resourceValues == null || CollectionUtils.isEmpty(resourceValues.getValues())) {
                    ret = policyValues == null || CollectionUtils.isEmpty(policyValues.getValues());
                } else if (policyValues != null && CollectionUtils.isNotEmpty(policyValues.getValues())) {
                    ret = CollectionUtils.isEqualCollection(resourceValues.getValues(), policyValues.getValues());
                }
                if (ret) continue;
                break;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("isCompleteMatch(): keysMatch=false. resourceKeys=" + resourceKeys + "; policyKeys=" + policyKeys);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resources + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isMatch(RangerPolicy policy, RangerPolicyResourceMatcher.MatchScope scope, Map<String, Object> evalContext) {
        return this.isMatch(policy, Collections.emptyMap(), scope, evalContext);
    }

    @Override
    public boolean isMatch(RangerPolicy policy, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes, RangerPolicyResourceMatcher.MatchScope scope, Map<String, Object> evalContext) {
        List<RangerServiceDef.RangerResourceDef> hierarchy;
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG, "RangerDefaultPolicyResourceMatcher.getPoliciesNonLegacy()");
        }
        Map<String, RangerPolicy.RangerPolicyResource> resources = policy.getResources();
        if (policy.getPolicyType() == this.policyType && MapUtils.isNotEmpty(resources) && CollectionUtils.isNotEmpty(hierarchy = this.getMatchingHierarchy(resources.keySet()))) {
            RangerPolicyResourceMatcher.MatchType matchType = RangerPolicyResourceMatcher.MatchType.NONE;
            RangerAccessResourceImpl accessResource = new RangerAccessResourceImpl();
            accessResource.setServiceDef(this.serviceDef);
            boolean skipped = false;
            for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
                String name = resourceDef.getName();
                RangerPolicy.RangerPolicyResource policyResource = resources.get(name);
                if (policyResource != null && CollectionUtils.isNotEmpty(policyResource.getValues())) {
                    ret = false;
                    matchType = RangerPolicyResourceMatcher.MatchType.NONE;
                    if (skipped) break;
                    for (String value : policyResource.getValues()) {
                        accessResource.setValue(name, value);
                        matchType = this.getMatchType(accessResource, scopes, evalContext);
                        if (matchType == RangerPolicyResourceMatcher.MatchType.NONE) continue;
                        ret = true;
                        break;
                    }
                } else {
                    skipped = true;
                }
                if (ret) continue;
                break;
            }
            ret = ret && this.isMatch(scope, matchType);
        }
        RangerPerfTracer.log(perf);
        return ret;
    }

    @Override
    public boolean isMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        return this.isMatch(resource, Collections.emptyMap(), evalContext);
    }

    @Override
    public boolean isMatch(RangerAccessResource resource, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes, Map<String, Object> evalContext) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG, "RangerDefaultPolicyResourceMatcher.grantRevokeMatch()");
        }
        HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = null;
        for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
            String resourceName = resourceDef.getName();
            Object resourceValue = resource.getValue(resourceName);
            if (resourceValue instanceof String) {
                String strValue = (String)resourceValue;
                if (policyResources == null) {
                    policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
                }
                policyResources.put(resourceName, new RangerPolicy.RangerPolicyResource(strValue));
                continue;
            }
            if (resourceValue == null) continue;
            policyResources = null;
            break;
        }
        boolean ret = MapUtils.isNotEmpty(policyResources) && this.isMatch(policyResources, scopes, evalContext);
        RangerPerfTracer.log(perf);
        return ret;
    }

    @Override
    public boolean isMatch(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        return this.isMatch(resources, Collections.emptyMap(), evalContext);
    }

    @Override
    public boolean isMatch(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyResourceMatcher.isMatch(" + resources + ", " + evalContext + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG, "RangerDefaultPolicyResourceMatcher.delegateAdminMatch()");
        }
        if (this.serviceDef != null && this.serviceDef.getResources() != null) {
            boolean keysMatch;
            Set<String> resourceKeys = resources == null ? null : resources.keySet();
            Set<String> policyKeys = this.policyResources == null ? null : this.policyResources.keySet();
            boolean bl = keysMatch = CollectionUtils.isEmpty(resourceKeys) || policyKeys != null && policyKeys.containsAll(resourceKeys);
            if (keysMatch) {
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    RangerResourceMatcher matcher;
                    String resourceName = resourceDef.getName();
                    RangerPolicy.RangerPolicyResource resourceValues = resources == null ? null : resources.get(resourceName);
                    List<String> values = resourceValues == null ? null : resourceValues.getValues();
                    RangerResourceMatcher rangerResourceMatcher = matcher = this.allMatchers == null ? null : this.allMatchers.get(resourceName);
                    if (matcher != null) {
                        if (CollectionUtils.isNotEmpty(values)) {
                            String value;
                            Iterator<String> iterator = values.iterator();
                            while (iterator.hasNext() && (ret = matcher.isMatch(value = iterator.next(), scopes.get(resourceName), evalContext))) {
                            }
                        } else {
                            ret = matcher.isMatchAny();
                        }
                    } else {
                        ret = CollectionUtils.isEmpty(values);
                    }
                    if (ret) continue;
                    break;
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("isMatch(): keysMatch=false. resourceKeys=" + resourceKeys + "; policyKeys=" + policyKeys);
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyResourceMatcher.isMatch(" + resources + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isMatch(RangerAccessResource resource, RangerPolicyResourceMatcher.MatchScope scope, Map<String, Object> evalContext) {
        return this.isMatch(resource, Collections.emptyMap(), scope, evalContext);
    }

    @Override
    public boolean isMatch(RangerAccessResource resource, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes, RangerPolicyResourceMatcher.MatchScope scope, Map<String, Object> evalContext) {
        RangerPolicyResourceMatcher.MatchType matchType = this.getMatchType(resource, scopes, evalContext);
        return this.isMatch(scope, matchType);
    }

    @Override
    public RangerPolicyResourceMatcher.MatchType getMatchType(RangerAccessResource resource, Map<String, Object> evalContext) {
        return this.getMatchType(resource, Collections.emptyMap(), evalContext);
    }

    @Override
    public RangerPolicyResourceMatcher.MatchType getMatchType(RangerAccessResource resource, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyResourceMatcher.getMatchType(" + resource + evalContext + ")");
        }
        RangerPolicyResourceMatcher.MatchType ret = RangerPolicyResourceMatcher.MatchType.NONE;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_RESOURCE_MATCHER_MATCH_LOG, "RangerDefaultPolicyResourceMatcher.getMatchType()");
        }
        if (resource != null && this.policyResources != null) {
            int resourceKeysSize;
            int n = resourceKeysSize = resource.getKeys() == null ? 0 : resource.getKeys().size();
            if (this.policyResources.size() == 0 && resourceKeysSize == 0) {
                ret = RangerPolicyResourceMatcher.MatchType.SELF;
            } else {
                List<RangerServiceDef.RangerResourceDef> hierarchy = this.getMatchingHierarchy(resource);
                if (CollectionUtils.isNotEmpty(hierarchy)) {
                    RangerServiceDef.RangerResourceDef resourceDef2;
                    RangerResourceMatcher matcher;
                    int lastNonAnyMatcherIndex = -1;
                    int matchersSize = 0;
                    Iterator<RangerServiceDef.RangerResourceDef> iterator = hierarchy.iterator();
                    while (iterator.hasNext() && (matcher = this.getResourceMatcher((resourceDef2 = iterator.next()).getName())) != null) {
                        if (!matcher.isMatchAny()) {
                            lastNonAnyMatcherIndex = matchersSize;
                        }
                        ++matchersSize;
                    }
                    if (resourceKeysSize == 0) {
                        ret = RangerPolicyResourceMatcher.MatchType.SELF;
                    }
                    for (RangerServiceDef.RangerResourceDef resourceDef2 : hierarchy) {
                        matcher = this.getResourceMatcher(resourceDef2.getName());
                        Object resourceValue = resource.getValue(resourceDef2.getName());
                        if (matcher != null) {
                            if (resourceValue == null && !matcher.isMatchAny()) continue;
                            if (matcher.isMatch(resourceValue, scopes.get(resourceDef2.getName()), evalContext)) {
                                ret = RangerPolicyResourceMatcher.MatchType.SELF;
                                continue;
                            }
                            ret = RangerPolicyResourceMatcher.MatchType.NONE;
                            break;
                        }
                        if (resourceValue == null) break;
                        ret = RangerPolicyResourceMatcher.MatchType.ANCESTOR;
                        break;
                    }
                    if (ret == RangerPolicyResourceMatcher.MatchType.SELF && resourceKeysSize < this.policyResources.size()) {
                        ret = resourceKeysSize > lastNonAnyMatcherIndex ? RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS : RangerPolicyResourceMatcher.MatchType.DESCENDANT;
                    }
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyResourceMatcher.getMatchType(" + resource + evalContext + "): " + (Object)((Object)ret));
        }
        return ret;
    }

    public static boolean isHierarchyValidForResources(List<RangerServiceDef.RangerResourceDef> hierarchy, Map<String, ?> resources) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isHierarchyValidForResources(" + StringUtils.join(hierarchy, (String)",") + ")");
        }
        boolean ret = true;
        if (hierarchy != null) {
            boolean skipped = false;
            for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
                String resourceName = resourceDef.getName();
                Object resourceValue = resources.get(resourceName);
                if (resourceValue == null) {
                    if (skipped) continue;
                    skipped = true;
                    continue;
                }
                if (!skipped) continue;
                ret = false;
                break;
            }
        } else {
            ret = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isHierarchyValidForResources(" + StringUtils.join(hierarchy, (String)",") + ") : " + ret);
        }
        return ret;
    }

    private List<RangerServiceDef.RangerResourceDef> getMatchingHierarchy(Set<String> resourceKeys) {
        List<RangerServiceDef.RangerResourceDef> ret = null;
        if (CollectionUtils.isNotEmpty(resourceKeys) && this.serviceDefHelper != null) {
            Set<List<RangerServiceDef.RangerResourceDef>> resourceHierarchies = this.serviceDefHelper.getResourceHierarchies(this.policyType, resourceKeys);
            for (List<RangerServiceDef.RangerResourceDef> resourceHierarchy : resourceHierarchies) {
                if (ret == null) {
                    ret = resourceHierarchy;
                    continue;
                }
                if (resourceHierarchy.size() >= ret.size() || (ret = resourceHierarchy).size() != resourceKeys.size()) continue;
                break;
            }
        }
        return ret;
    }

    private List<RangerServiceDef.RangerResourceDef> getMatchingHierarchy(RangerAccessResource resource) {
        List<RangerServiceDef.RangerResourceDef> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyResourceMatcher.getMatchingHierarchy(" + resource + ")");
        }
        Set<String> policyResourcesKeySet = this.policyResources.keySet();
        Set<String> resourceKeySet = resource.getKeys();
        if (CollectionUtils.isNotEmpty(resourceKeySet)) {
            List<RangerServiceDef.RangerResourceDef> aValidHierarchy = null;
            if (this.validResourceHierarchy != null && this.serviceDefHelper != null) {
                if (this.serviceDefHelper.hierarchyHasAllResources(this.validResourceHierarchy, resourceKeySet)) {
                    aValidHierarchy = this.validResourceHierarchy;
                }
            } else if (policyResourcesKeySet.containsAll(resourceKeySet)) {
                aValidHierarchy = this.getMatchingHierarchy(policyResourcesKeySet);
            } else if (resourceKeySet.containsAll(policyResourcesKeySet)) {
                aValidHierarchy = this.getMatchingHierarchy(resourceKeySet);
            }
            ret = RangerDefaultPolicyResourceMatcher.isHierarchyValidForResources(aValidHierarchy, resource.getAsMap()) ? aValidHierarchy : null;
        } else {
            List<RangerServiceDef.RangerResourceDef> list = ret = this.validResourceHierarchy != null ? this.validResourceHierarchy : this.getMatchingHierarchy(policyResourcesKeySet);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyResourceMatcher.getMatchingHierarchy(" + resource + "): " + ret);
        }
        return ret;
    }

    private boolean isMatch(RangerPolicyResourceMatcher.MatchScope scope, RangerPolicyResourceMatcher.MatchType matchType) {
        boolean ret;
        switch (scope) {
            case SELF: {
                ret = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS;
                break;
            }
            case ANCESTOR: {
                ret = matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR;
                break;
            }
            case DESCENDANT: {
                ret = matchType == RangerPolicyResourceMatcher.MatchType.DESCENDANT;
                break;
            }
            case SELF_OR_ANCESTOR: {
                ret = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS || matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR;
                break;
            }
            case SELF_OR_DESCENDANT: {
                ret = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS || matchType == RangerPolicyResourceMatcher.MatchType.DESCENDANT;
                break;
            }
            default: {
                ret = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
            }
        }
        return ret;
    }

    private RangerResourceMatcher createResourceMatcher(RangerServiceDef.RangerResourceDef resourceDef, RangerPolicy.RangerPolicyResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyResourceMatcher.createResourceMatcher(" + resourceDef + ", " + resource + ")");
        }
        RangerResourceMatcher ret = null;
        if (resourceDef != null) {
            String resName = resourceDef.getName();
            String clsName = resourceDef.getMatcher();
            if (this.pluginContext != null) {
                ret = this.pluginContext.getResourceMatcher(resName, resource);
            }
            if (ret == null) {
                if (!StringUtils.isEmpty((CharSequence)clsName)) {
                    try {
                        Class<?> matcherClass = Class.forName(clsName);
                        ret = (RangerResourceMatcher)matcherClass.newInstance();
                    }
                    catch (Exception excp) {
                        LOG.error("failed to instantiate resource matcher '" + clsName + "' for '" + resName + "'. Default resource matcher will be used", (Throwable)excp);
                    }
                }
                if (ret == null) {
                    ret = new RangerDefaultResourceMatcher();
                }
                if (this.forceEnableWildcardMatch && !Boolean.parseBoolean(resourceDef.getMatcherOptions().get("wildCard"))) {
                    resourceDef = this.serviceDefHelper.getWildcardEnabledResourceDef(resourceDef.getName(), this.policyType);
                }
                ret.setResourceDef(resourceDef);
                ret.setPolicyResource(resource);
                ret.init();
                if (this.pluginContext != null) {
                    this.pluginContext.setResourceMatcher(resName, resource, ret);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Did not create a fresh matcher - used matcher from pluginContext");
            }
        } else {
            LOG.error("RangerDefaultPolicyResourceMatcher: RangerResourceDef is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyResourceMatcher.createResourceMatcher(" + resourceDef + ", " + resource + "): " + ret);
        }
        return ret;
    }
}

