/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedServiceDefsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedServiceDefsUtil.class);
    public static final String DEFAULT_BOOTSTRAP_SERVICEDEF_LIST = "tag,hdfs,hbase,hive,kms,knox,storm,yarn,kafka,solr,atlas,nifi,nifi-registry,sqoop,kylin,elasticsearch,presto,trino,ozone,kudu,schema-registry,nestedstructure,polaris";
    private static final String PROPERTY_SUPPORTED_SERVICE_DEFS = "ranger.supportedcomponents";
    private Set<String> supportedServiceDefs;
    public static final String EMBEDDED_SERVICEDEF_TAG_NAME = "tag";
    public static final String EMBEDDED_SERVICEDEF_HDFS_NAME = "hdfs";
    public static final String EMBEDDED_SERVICEDEF_HBASE_NAME = "hbase";
    public static final String EMBEDDED_SERVICEDEF_HIVE_NAME = "hive";
    public static final String EMBEDDED_SERVICEDEF_KMS_NAME = "kms";
    public static final String EMBEDDED_SERVICEDEF_KNOX_NAME = "knox";
    public static final String EMBEDDED_SERVICEDEF_STORM_NAME = "storm";
    public static final String EMBEDDED_SERVICEDEF_YARN_NAME = "yarn";
    public static final String EMBEDDED_SERVICEDEF_KAFKA_NAME = "kafka";
    public static final String EMBEDDED_SERVICEDEF_SOLR_NAME = "solr";
    public static final String EMBEDDED_SERVICEDEF_SCHEMA_REGISTRY_NAME = "schema-registry";
    public static final String EMBEDDED_SERVICEDEF_NIFI_NAME = "nifi";
    public static final String EMBEDDED_SERVICEDEF_NIFI_REGISTRY_NAME = "nifi-registry";
    public static final String EMBEDDED_SERVICEDEF_ATLAS_NAME = "atlas";
    public static final String EMBEDDED_SERVICEDEF_WASB_NAME = "wasb";
    public static final String EMBEDDED_SERVICEDEF_SQOOP_NAME = "sqoop";
    public static final String EMBEDDED_SERVICEDEF_KYLIN_NAME = "kylin";
    public static final String EMBEDDED_SERVICEDEF_ABFS_NAME = "abfs";
    public static final String EMBEDDED_SERVICEDEF_ELASTICSEARCH_NAME = "elasticsearch";
    public static final String EMBEDDED_SERVICEDEF_PRESTO_NAME = "presto";
    public static final String EMBEDDED_SERVICEDEF_TRINO_NAME = "trino";
    public static final String EMBEDDED_SERVICEDEF_OZONE_NAME = "ozone";
    public static final String EMBEDDED_SERVICEDEF_KUDU_NAME = "kudu";
    public static final String EMBEDDED_SERVICEDEF_NESTEDSTRUCTURE_NAME = "nestedstructure";
    public static final String EMBEDDED_SERVICEDEF_POLARIS_NAME = "polaris";
    public static final String PROPERTY_CREATE_EMBEDDED_SERVICE_DEFS = "ranger.service.store.create.embedded.service-defs";
    public static final String HDFS_IMPL_CLASS_NAME = "org.apache.ranger.services.hdfs.RangerServiceHdfs";
    public static final String HBASE_IMPL_CLASS_NAME = "org.apache.ranger.services.hbase.RangerServiceHBase";
    public static final String HIVE_IMPL_CLASS_NAME = "org.apache.ranger.services.hive.RangerServiceHive";
    public static final String KMS_IMPL_CLASS_NAME = "org.apache.ranger.services.kms.RangerServiceKMS";
    public static final String KNOX_IMPL_CLASS_NAME = "org.apache.ranger.services.knox.RangerServiceKnox";
    public static final String STORM_IMPL_CLASS_NAME = "org.apache.ranger.services.storm.RangerServiceStorm";
    public static final String YARN_IMPL_CLASS_NAME = "org.apache.ranger.services.yarn.RangerServiceYarn";
    public static final String KAFKA_IMPL_CLASS_NAME = "org.apache.ranger.services.kafka.RangerServiceKafka";
    public static final String SOLR_IMPL_CLASS_NAME = "org.apache.ranger.services.solr.RangerServiceSolr";
    public static final String SCHEMA_REGISTRY_IMPL_CLASS_NAME = "org.apache.ranger.services.schemaregistry.RangerServiceSchemaRegistry";
    public static final String NIFI_IMPL_CLASS_NAME = "org.apache.ranger.services.nifi.RangerServiceNiFi";
    public static final String ATLAS_IMPL_CLASS_NAME = "org.apache.ranger.services.atlas.RangerServiceAtlas";
    public static final String PRESTO_IMPL_CLASS_NAME = "org.apache.ranger.services.presto.RangerServicePresto";
    public static final String TRINO_IMPL_CLASS_NAME = "org.apache.ranger.services.trino.RangerServiceTrino";
    public static final String OZONE_IMPL_CLASS_NAME = "org.apache.ranger.services.ozone.RangerServiceOzone";
    public static final String KUDU_IMPL_CLASS_NAME = "org.apache.ranger.services.kudu.RangerServiceKudu";
    private static EmbeddedServiceDefsUtil instance = new EmbeddedServiceDefsUtil();
    private boolean createEmbeddedServiceDefs = true;
    private RangerServiceDef hdfsServiceDef;
    private RangerServiceDef hBaseServiceDef;
    private RangerServiceDef hiveServiceDef;
    private RangerServiceDef kmsServiceDef;
    private RangerServiceDef knoxServiceDef;
    private RangerServiceDef stormServiceDef;
    private RangerServiceDef yarnServiceDef;
    private RangerServiceDef kafkaServiceDef;
    private RangerServiceDef solrServiceDef;
    private RangerServiceDef schemaRegistryServiceDef;
    private RangerServiceDef nifiServiceDef;
    private RangerServiceDef nifiRegistryServiceDef;
    private RangerServiceDef atlasServiceDef;
    private RangerServiceDef wasbServiceDef;
    private RangerServiceDef sqoopServiceDef;
    private RangerServiceDef kylinServiceDef;
    private RangerServiceDef abfsServiceDef;
    private RangerServiceDef elasticsearchServiceDef;
    private RangerServiceDef prestoServiceDef;
    private RangerServiceDef trinoServiceDef;
    private RangerServiceDef ozoneServiceDef;
    private RangerServiceDef kuduServiceDef;
    private RangerServiceDef nestedStructureServiveDef;
    private RangerServiceDef polarisServiceDef;
    private RangerServiceDef tagServiceDef;
    private final RangerAdminConfig config = RangerAdminConfig.getInstance();

    private EmbeddedServiceDefsUtil() {
    }

    public static EmbeddedServiceDefsUtil instance() {
        return instance;
    }

    public void init(ServiceStore store) {
        LOG.info("==> EmbeddedServiceDefsUtil.init()");
        try {
            this.createEmbeddedServiceDefs = this.config.getBoolean(PROPERTY_CREATE_EMBEDDED_SERVICE_DEFS, true);
            this.supportedServiceDefs = this.getSupportedServiceDef();
            this.tagServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_TAG_NAME);
            this.hdfsServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_HDFS_NAME);
            this.hBaseServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_HBASE_NAME);
            this.hiveServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_HIVE_NAME);
            this.kmsServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KMS_NAME);
            this.knoxServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KNOX_NAME);
            this.stormServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_STORM_NAME);
            this.yarnServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_YARN_NAME);
            this.kafkaServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KAFKA_NAME);
            this.solrServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_SOLR_NAME);
            this.schemaRegistryServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_SCHEMA_REGISTRY_NAME);
            this.nifiServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_NIFI_NAME);
            this.nifiRegistryServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_NIFI_REGISTRY_NAME);
            this.atlasServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_ATLAS_NAME);
            this.wasbServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_WASB_NAME);
            this.sqoopServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_SQOOP_NAME);
            this.kylinServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KYLIN_NAME);
            this.abfsServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_ABFS_NAME);
            this.elasticsearchServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_ELASTICSEARCH_NAME);
            this.trinoServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_TRINO_NAME);
            this.prestoServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_PRESTO_NAME);
            this.ozoneServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_OZONE_NAME);
            this.kuduServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KUDU_NAME);
            this.nestedStructureServiveDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_NESTEDSTRUCTURE_NAME);
            this.polarisServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_POLARIS_NAME);
        }
        catch (Throwable excp) {
            LOG.error("EmbeddedServiceDefsUtil.init(): failed", excp);
        }
        LOG.info("<== EmbeddedServiceDefsUtil.init()");
    }

    public long getHdfsServiceDefId() {
        return this.getId(this.hdfsServiceDef);
    }

    public long getHBaseServiceDefId() {
        return this.getId(this.hBaseServiceDef);
    }

    public long getHiveServiceDefId() {
        return this.getId(this.hiveServiceDef);
    }

    public long getKmsServiceDefId() {
        return this.getId(this.kmsServiceDef);
    }

    public long getKnoxServiceDefId() {
        return this.getId(this.knoxServiceDef);
    }

    public long getStormServiceDefId() {
        return this.getId(this.stormServiceDef);
    }

    public long getYarnServiceDefId() {
        return this.getId(this.yarnServiceDef);
    }

    public long getKafkaServiceDefId() {
        return this.getId(this.kafkaServiceDef);
    }

    public long getSolrServiceDefId() {
        return this.getId(this.solrServiceDef);
    }

    public long getSchemaRegistryServiceDefId() {
        return this.getId(this.schemaRegistryServiceDef);
    }

    public long getNiFiServiceDefId() {
        return this.getId(this.nifiServiceDef);
    }

    public long getNiFiRegistryServiceDefId() {
        return this.getId(this.nifiRegistryServiceDef);
    }

    public long getAtlasServiceDefId() {
        return this.getId(this.atlasServiceDef);
    }

    public long getSqoopServiceDefId() {
        return this.getId(this.sqoopServiceDef);
    }

    public long getKylinServiceDefId() {
        return this.getId(this.kylinServiceDef);
    }

    public long getElasticsearchServiceDefId() {
        return this.getId(this.elasticsearchServiceDef);
    }

    public long getTagServiceDefId() {
        return this.getId(this.tagServiceDef);
    }

    public long getWasbServiceDefId() {
        return this.getId(this.wasbServiceDef);
    }

    public long getAbfsServiceDefId() {
        return this.getId(this.abfsServiceDef);
    }

    public long getTrinoServiceDefId() {
        return this.getId(this.trinoServiceDef);
    }

    public long getPrestoServiceDefId() {
        return this.getId(this.prestoServiceDef);
    }

    public long getOzoneServiceDefId() {
        return this.getId(this.ozoneServiceDef);
    }

    public long getKuduServiceDefId() {
        return this.getId(this.kuduServiceDef);
    }

    public long getNestedStructureServiceDefId() {
        return this.getId(this.nestedStructureServiveDef);
    }

    public long getPolarisServiceDefId() {
        return this.getId(this.polarisServiceDef);
    }

    public RangerServiceDef getEmbeddedServiceDef(String defType) throws Exception {
        RangerServiceDef serviceDef = null;
        if (StringUtils.isNotEmpty((CharSequence)defType)) {
            serviceDef = this.loadEmbeddedServiceDef(defType);
        }
        return serviceDef;
    }

    public static boolean isRecursiveEnabled(RangerServiceDef rangerServiceDef, String resourceDefName) {
        boolean ret = false;
        List<RangerServiceDef.RangerResourceDef> resourceDefs = rangerServiceDef.getResources();
        for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
            if (!resourceDefName.equals(resourceDef.getName())) continue;
            ret = resourceDef.getRecursiveSupported();
            break;
        }
        return ret;
    }

    private long getId(RangerServiceDef serviceDef) {
        return serviceDef == null || serviceDef.getId() == null ? -1L : serviceDef.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangerServiceDef getOrCreateServiceDef(ServiceStore store, String serviceDefName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EmbeddedServiceDefsUtil.getOrCreateServiceDef(" + serviceDefName + ")");
        }
        RangerServiceDef ret = null;
        boolean createServiceDef = CollectionUtils.isEmpty(this.supportedServiceDefs) || this.supportedServiceDefs.contains(serviceDefName);
        try {
            ret = store.getServiceDefByName(serviceDefName);
            if (ret == null && this.createEmbeddedServiceDefs && createServiceDef) {
                ret = ServiceDefUtil.normalize(this.loadEmbeddedServiceDef(serviceDefName));
                LOG.info("creating embedded service-def " + serviceDefName);
                if (ret.getId() != null) {
                    store.setPopulateExistingBaseFields(true);
                    try {
                        ret = store.createServiceDef(ret);
                    }
                    finally {
                        store.setPopulateExistingBaseFields(false);
                    }
                } else {
                    ret = store.createServiceDef(ret);
                }
                LOG.info("created embedded service-def " + serviceDefName);
            }
        }
        catch (Exception excp) {
            LOG.error("EmbeddedServiceDefsUtil.getOrCreateServiceDef(): failed to load/create serviceType " + serviceDefName, (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EmbeddedServiceDefsUtil.getOrCreateServiceDef(" + serviceDefName + "): " + ret);
        }
        return ret;
    }

    private RangerServiceDef loadEmbeddedServiceDef(String serviceType) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EmbeddedServiceDefsUtil.loadEmbeddedServiceDef(" + serviceType + ")");
        }
        RangerServiceDef ret = null;
        String resource = "/service-defs/ranger-servicedef-" + serviceType + ".json";
        InputStream inStream = this.getClass().getResourceAsStream(resource);
        InputStreamReader reader = new InputStreamReader(inStream);
        ret = JsonUtils.jsonToObject(reader, RangerServiceDef.class);
        if (ret != null && StringUtils.isBlank((CharSequence)ret.getDisplayName())) {
            ret.setDisplayName(ret.getName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EmbeddedServiceDefsUtil.loadEmbeddedServiceDef(" + serviceType + ")");
        }
        return ret;
    }

    private Set<String> getSupportedServiceDef() {
        HashSet<String> supportedServiceDef = new HashSet<String>();
        try {
            String[] supportedComponents;
            String ranger_supportedcomponents = this.config.get(PROPERTY_SUPPORTED_SERVICE_DEFS, DEFAULT_BOOTSTRAP_SERVICEDEF_LIST);
            if (StringUtils.isBlank((CharSequence)ranger_supportedcomponents) || "all".equalsIgnoreCase(ranger_supportedcomponents)) {
                ranger_supportedcomponents = DEFAULT_BOOTSTRAP_SERVICEDEF_LIST;
            }
            if ((supportedComponents = ranger_supportedcomponents.split(",")) != null && supportedComponents.length > 0) {
                for (String element : supportedComponents) {
                    if (StringUtils.isBlank((CharSequence)element)) continue;
                    element = element.toLowerCase();
                    supportedServiceDef.add(element);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("EmbeddedServiceDefsUtil.getSupportedServiceDef(): failed", (Throwable)ex);
        }
        return supportedServiceDef;
    }
}

