/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive.client;

import java.io.Closeable;
import java.io.File;
import java.net.MalformedURLException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveClient
extends BaseClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HiveClient.class);
    private static final String ERR_MSG = "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private Connection con;
    private HiveMetaStoreClient hiveClient;
    private String hiveSiteFilePath;
    private boolean isKerberosAuth;
    private boolean enableHiveMetastoreLookup;

    public HiveClient(String serviceName) throws Exception {
        super(serviceName, null);
        this.initHive();
    }

    public HiveClient(String serviceName, Map<String, String> connectionProp) throws Exception {
        super(serviceName, connectionProp);
        this.initHive();
    }

    public void initHive() throws Exception {
        this.enableHiveMetastoreLookup = this.getConfigHolder().isEnableHiveMetastoreLookup();
        this.hiveSiteFilePath = this.getConfigHolder().getHiveSiteFilePath();
        this.isKerberosAuth = this.getConfigHolder().isKerberosAuthentication();
        if (this.isKerberosAuth) {
            LOG.info("Secured Mode: JDBC Connection done with preAuthenticated Subject");
            Subject.doAs(this.getLoginSubject(), new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HiveClient.this.initConnection();
                    return null;
                }
            });
        } else {
            LOG.info("Since Password is NOT provided, Trying to use UnSecure client with username and password");
            final String userName = this.getConfigHolder().getUserName();
            final String password = this.getConfigHolder().getPassword();
            Subject.doAs(this.getLoginSubject(), new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HiveClient.this.initConnection(userName, password);
                    return null;
                }
            });
        }
    }

    public List<String> getDatabaseList(String databaseMatching, List<String> databaseList) throws HadoopException {
        final String dbMatching = databaseMatching;
        final List<String> dbList = databaseList;
        List<String> dblist = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = HiveClient.this.enableHiveMetastoreLookup ? HiveClient.this.getDBListFromHM(dbMatching, dbList) : HiveClient.this.getDBList(dbMatching, dbList);
                }
                catch (HadoopException he) {
                    LOG.error("<== HiveClient getDatabaseList() :Unable to get the Database List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return dblist;
    }

    private List<String> getDBListFromHM(String databaseMatching, List<String> dbList) throws HadoopException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveClient getDBListFromHM databaseMatching : " + databaseMatching + " ExcludedbList : " + dbList);
        }
        ArrayList<String> ret = new ArrayList<String>();
        try {
            List hiveDBList = null;
            if (this.hiveClient != null) {
                hiveDBList = databaseMatching.equalsIgnoreCase("*") ? this.hiveClient.getAllDatabases() : this.hiveClient.getDatabases(databaseMatching);
            }
            if (hiveDBList != null) {
                for (String dbName : hiveDBList) {
                    if (dbList != null && dbList.contains(dbName)) continue;
                    ret.add(dbName);
                }
            }
        }
        catch (TException e) {
            String msgDesc = "Unable to get Database";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
            hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== HiveClient.getDBListFromHM() Error : ", (Throwable)e);
            }
            throw hdpException;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveClient.getDBListFromHM(): " + ret);
        }
        return ret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getDBList(String databaseMatching, List<String> dbList) throws HadoopException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveClient getDBList databaseMatching : " + databaseMatching + " ExcludedbList :" + dbList);
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con != null) {
            Statement stat = null;
            ResultSet rs = null;
            String sql = "show databases";
            if (databaseMatching != null && !databaseMatching.isEmpty()) {
                sql = sql + " like \"" + databaseMatching + "\"";
            }
            try {
                stat = this.con.createStatement();
                rs = stat.executeQuery(sql);
                while (rs.next()) {
                    String dbName = rs.getString(1);
                    if (dbList != null && dbList.contains(dbName)) continue;
                    ret.add(rs.getString(1));
                }
                this.close(rs);
                this.close(stat);
            }
            catch (SQLTimeoutException sqlt) {
                try {
                    String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<== HiveClient.getDBList() Error : ", (Throwable)sqlt);
                    }
                    throw hdpException;
                    catch (SQLException sqle) {
                        msgDesc = "Unable to execute SQL [" + sql + "].";
                        hdpException = new HadoopException(msgDesc, (Throwable)sqle);
                        hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("<== HiveClient.getDBList() Error : ", (Throwable)sqle);
                        }
                        throw hdpException;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    this.close(stat);
                    throw throwable;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveClient.getDBList(): " + ret);
        }
        return ret;
    }

    public List<String> getTableList(String tableNameMatching, List<String> databaseList, List<String> tblNameList) throws HadoopException {
        final String tblNameMatching = tableNameMatching;
        final List<String> dbList = databaseList;
        final List<String> tblList = tblNameList;
        List<String> tableList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = HiveClient.this.enableHiveMetastoreLookup ? HiveClient.this.getTblListFromHM(tblNameMatching, dbList, tblList) : HiveClient.this.getTblList(tblNameMatching, dbList, tblList);
                }
                catch (HadoopException he) {
                    LOG.error("<== HiveClient getTableList() :Unable to get the Table List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return tableList;
    }

    private List<String> getTblListFromHM(String tableNameMatching, List<String> dbList, List<String> tblList) throws HadoopException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveClient getTblListFromHM() tableNameMatching : " + tableNameMatching + " ExcludedbList :" + dbList + "ExcludeTableList :" + tblList);
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (this.hiveClient != null && dbList != null && !dbList.isEmpty()) {
            for (String dbName : dbList) {
                try {
                    List hiveTblList = this.hiveClient.getTables(dbName, tableNameMatching);
                    for (String tblName : hiveTblList) {
                        if (tblList != null && tblList.contains(tblName)) continue;
                        ret.add(tblName);
                    }
                }
                catch (MetaException e) {
                    String msgDesc = "Unable to get Table.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<== HiveClient.getTblListFromHM() Error : ", (Throwable)e);
                    }
                    throw hdpException;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveClient getTblListFromHM() " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getTblList(String tableNameMatching, List<String> dbList, List<String> tblList) throws HadoopException {
        ArrayList<String> ret;
        block16: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> HiveClient getTblList() tableNameMatching : " + tableNameMatching + " ExcludedbList :" + dbList + "ExcludeTableList :" + tblList);
            }
            ret = new ArrayList<String>();
            if (this.con != null) {
                Statement stat = null;
                ResultSet rs = null;
                String sql = null;
                try {
                    if (dbList == null || dbList.isEmpty()) break block16;
                    for (String db : dbList) {
                        sql = "use " + db;
                        try {
                            stat = this.con.createStatement();
                            stat.execute(sql);
                        }
                        finally {
                            this.close(stat);
                            stat = null;
                        }
                        sql = "show tables ";
                        if (tableNameMatching != null && !tableNameMatching.isEmpty()) {
                            sql = sql + " like \"" + tableNameMatching + "\"";
                        }
                        try {
                            stat = this.con.createStatement();
                            rs = stat.executeQuery(sql);
                            while (rs.next()) {
                                String tblName = rs.getString(1);
                                if (tblList != null && tblList.contains(tblName)) continue;
                                ret.add(tblName);
                            }
                            this.close(rs);
                            this.close(stat);
                            rs = null;
                            stat = null;
                        }
                        catch (Throwable throwable) {
                            this.close(rs);
                            this.close(stat);
                            rs = null;
                            stat = null;
                            throw throwable;
                        }
                    }
                }
                catch (SQLTimeoutException sqlt) {
                    String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<== HiveClient.getTblList() Error : ", (Throwable)sqlt);
                    }
                    throw hdpException;
                }
                catch (SQLException sqle) {
                    String msgDesc = "Unable to execute SQL [" + sql + "].";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<== HiveClient.getTblList() Error : ", (Throwable)sqle);
                    }
                    throw hdpException;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveClient getTblList() " + ret);
        }
        return ret;
    }

    public List<String> getViewList(String database, String viewNameMatching) {
        List<String> ret = null;
        return ret;
    }

    public List<String> getUDFList(String database, String udfMatching) {
        List<String> ret = null;
        return ret;
    }

    public List<String> getColumnList(String columnNameMatching, List<String> dbList, List<String> tblList, List<String> colList) throws HadoopException {
        final String clmNameMatching = columnNameMatching;
        final List<String> databaseList = dbList;
        final List<String> tableList = tblList;
        final List<String> clmList = colList;
        List<String> columnList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = HiveClient.this.enableHiveMetastoreLookup ? HiveClient.this.getClmListFromHM(clmNameMatching, databaseList, tableList, clmList) : HiveClient.this.getClmList(clmNameMatching, databaseList, tableList, clmList);
                }
                catch (HadoopException he) {
                    LOG.error("<== HiveClient getColumnList() :Unable to get the Column List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return columnList;
    }

    private List<String> getClmListFromHM(String columnNameMatching, List<String> dbList, List<String> tblList, List<String> colList) throws HadoopException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveClient.getClmListFromHM() columnNameMatching: " + columnNameMatching + " dbList :" + dbList + " tblList: " + tblList + " colList: " + colList);
        }
        ArrayList<String> ret = new ArrayList<String>();
        String columnNameMatchingRegEx = null;
        if (columnNameMatching != null && !columnNameMatching.isEmpty()) {
            columnNameMatchingRegEx = columnNameMatching;
        }
        if (this.hiveClient != null && dbList != null && !dbList.isEmpty() && tblList != null && !tblList.isEmpty()) {
            for (String db : dbList) {
                for (String tbl : tblList) {
                    try {
                        List hiveSch = this.hiveClient.getFields(db, tbl);
                        if (hiveSch == null) continue;
                        for (FieldSchema sch : hiveSch) {
                            String columnName = sch.getName();
                            if (colList != null && colList.contains(columnName)) continue;
                            if (columnNameMatchingRegEx == null) {
                                ret.add(columnName);
                                continue;
                            }
                            if (!FilenameUtils.wildcardMatch((String)columnName, (String)columnNameMatchingRegEx)) continue;
                            ret.add(columnName);
                        }
                    }
                    catch (TException e) {
                        String msgDesc = "Unable to get Columns.";
                        HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                        hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("<== HiveClient.getClmListFromHM() Error : ", (Throwable)e);
                        }
                        throw hdpException;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveClient.getClmListFromHM() " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getClmList(String columnNameMatching, List<String> dbList, List<String> tblList, List<String> colList) throws HadoopException {
        if (HiveClient.LOG.isDebugEnabled()) {
            HiveClient.LOG.debug("==> HiveClient.getClmList() columnNameMatching: " + columnNameMatching + " dbList :" + dbList + " tblList: " + tblList + " colList: " + colList);
        }
        ret = new ArrayList<String>();
        if (this.con == null) ** GOTO lbl15
        columnNameMatchingRegEx = null;
        if (columnNameMatching != null && !columnNameMatching.isEmpty()) {
            columnNameMatchingRegEx = columnNameMatching;
        }
        stat = null;
        rs = null;
        sql = null;
        if (dbList == null || dbList.isEmpty() || tblList == null || tblList.isEmpty()) ** GOTO lbl15
        var10_10 = dbList.iterator();
        block8: while (true) {
            block21: {
                if (var10_10.hasNext()) break block21;
lbl15:
                // 3 sources

                if (HiveClient.LOG.isDebugEnabled()) {
                    HiveClient.LOG.debug("<== HiveClient.getClmList() " + ret);
                }
                return ret;
            }
            db = var10_10.next();
            var12_12 = tblList.iterator();
            while (true) {
                if (!var12_12.hasNext()) continue block8;
                tbl = var12_12.next();
                try {
                    sql = "use " + db;
                    try {
                        stat = this.con.createStatement();
                        stat.execute(sql);
                    }
                    finally {
                        this.close(stat);
                    }
                    sql = "describe  " + tbl;
                    stat = this.con.createStatement();
                    rs = stat.executeQuery(sql);
                    while (rs.next()) {
                        columnName = rs.getString(1);
                        if (colList != null && colList.contains(columnName)) continue;
                        if (columnNameMatchingRegEx == null) {
                            ret.add(columnName);
                            continue;
                        }
                        if (!FilenameUtils.wildcardMatch((String)columnName, (String)columnNameMatchingRegEx)) continue;
                        ret.add(columnName);
                    }
                    this.close(rs);
                    this.close(stat);
                }
                catch (SQLTimeoutException sqlt) {
                    try {
                        msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                        hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                        hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqlt), msgDesc + "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                        if (HiveClient.LOG.isDebugEnabled()) {
                            HiveClient.LOG.debug("<== HiveClient.getClmList() Error : ", (Throwable)sqlt);
                        }
                        throw hdpException;
                        catch (SQLException sqle) {
                            msgDesc = "Unable to execute SQL [" + sql + "].";
                            hdpException = new HadoopException(msgDesc, (Throwable)sqle);
                            hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqle), msgDesc + "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            if (HiveClient.LOG.isDebugEnabled()) {
                                HiveClient.LOG.debug("<== HiveClient.getClmList() Error : ", (Throwable)sqle);
                            }
                            throw hdpException;
                        }
                    }
                    catch (Throwable var17_22) {
                        this.close(rs);
                        this.close(stat);
                        throw var17_22;
                    }
                }
            }
            break;
        }
    }

    @Override
    public void close() {
        Subject.doAs(this.getLoginSubject(), new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                HiveClient.this.close(HiveClient.this.con);
                return null;
            }
        });
    }

    private void close(Statement aStat) {
        try {
            if (aStat != null) {
                aStat.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close SQL statement", (Throwable)e);
        }
    }

    private void close(ResultSet aResultSet) {
        try {
            if (aResultSet != null) {
                aResultSet.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close ResultSet", (Throwable)e);
        }
    }

    private void close(Connection aCon) {
        try {
            if (aCon != null) {
                aCon.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close SQL Connection", (Throwable)e);
        }
    }

    private void initConnection() throws HadoopException {
        try {
            this.initConnection(null, null);
        }
        catch (HadoopException he) {
            LOG.error("Unable to Connect to Hive", (Throwable)he);
            throw he;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection(String userName, String password) throws HadoopException {
        block44: {
            if (this.enableHiveMetastoreLookup) {
                try {
                    HiveConf conf = new HiveConf();
                    if (!StringUtils.isEmpty((CharSequence)this.hiveSiteFilePath)) {
                        File f = new File(this.hiveSiteFilePath);
                        if (f.exists()) {
                            conf.addResource(f.toURI().toURL());
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Hive site conf file path " + this.hiveSiteFilePath + " does not exists for Hive Metastore lookup");
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Hive site conf file path property not found for Hive Metastore lookup");
                    }
                    this.hiveClient = new HiveMetaStoreClient((Configuration)conf);
                }
                catch (HadoopException he) {
                    String msgDesc = "initConnection: Class or its nullary constructor might not accessible.So unable to initiate connection to hive thrift server instance.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)he);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)he), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (MalformedURLException e) {
                    String msgDesc = "initConnection: URL might be malformed.So unable to initiate connection to hive thrift server instance.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (MetaException e) {
                    String msgDesc = "initConnection: Meta info is not proper.So unable to initiate connection to hive thrift server instance.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (Throwable t) {
                    String msgDesc = "Unable to connect to Hive Thrift Server instance";
                    HadoopException hdpException = new HadoopException(msgDesc, t);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
            }
            Properties prop = this.getConfigHolder().getRangerSection();
            String driverClassName = prop.getProperty("jdbc.driverClassName");
            String url = prop.getProperty("jdbc.url");
            if (driverClassName != null) {
                try {
                    Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                    DriverManager.registerDriver(driver);
                }
                catch (SQLException e) {
                    String msgDesc = "initConnection: Caught SQLException while registering Hive driver, so Unable to connect to Hive Thrift Server instance.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (IllegalAccessException ilae) {
                    String msgDesc = "initConnection: Class or its nullary constructor might not accessible.So unable to initiate connection to hive thrift server instance.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ilae);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)ilae), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (InstantiationException ie) {
                    String msgDesc = "initConnection: Class may not have its nullary constructor or may be the instantiation fails for some other reason.So unable to initiate connection to hive thrift server instance.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ie);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)ie), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (ExceptionInInitializerError eie) {
                    String msgDesc = "initConnection: Got ExceptionInInitializerError, The initialization provoked by this method fails.So unable to initiate connection to hive thrift server instance.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)eie);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)eie), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (SecurityException se) {
                    String msgDesc = "initConnection: unable to initiate connection to hive thrift server instance, The caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of s.checkPackageAccess() denies access to the package of this class.";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)se), msgDesc + ERR_MSG, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
                catch (Throwable t) {
                    String msgDesc = "initConnection: Unable to connect to Hive Thrift Server instance, please provide valid value of field : {jdbc.driverClassName}.";
                    HadoopException hdpException = new HadoopException(msgDesc, t);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, "jdbc.driverClassName");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msgDesc, (Throwable)hdpException);
                    }
                    throw hdpException;
                }
            }
            try {
                if (userName == null && password == null) {
                    this.con = DriverManager.getConnection(url);
                    break block44;
                }
                String decryptedPwd = null;
                try {
                    decryptedPwd = PasswordUtils.decryptPassword((String)password);
                }
                catch (Exception ex) {
                    LOG.info("Password decryption failed; trying Hive connection with received password string");
                    decryptedPwd = null;
                }
                finally {
                    if (decryptedPwd == null) {
                        decryptedPwd = password;
                    }
                }
                this.con = DriverManager.getConnection(url, userName, decryptedPwd);
            }
            catch (SQLException e) {
                String msgDesc = "Unable to connect to Hive Thrift Server instance.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
            catch (SecurityException se) {
                String msgDesc = "Unable to connect to Hive Thrift Server instance.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)se), msgDesc + ERR_MSG, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
            catch (Throwable t) {
                String msgDesc = "Unable to connect to Hive Thrift Server instance";
                HadoopException hdpException = new HadoopException(msgDesc, t);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, url);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block23: {
            HiveClient hc = null;
            if (args.length == 0) {
                System.err.println("USAGE: java " + HiveClient.class.getName() + " dataSourceName <databaseName> <tableName> <columnName>");
                System.exit(1);
            }
            try {
                hc = new HiveClient(args[0]);
                if (args.length == 2) {
                    List<String> dbList = null;
                    try {
                        dbList = hc.getDatabaseList(args[1], null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (CollectionUtils.isEmpty(dbList)) {
                        System.out.println("No database found with db filter [" + args[1] + "]");
                    } else if (CollectionUtils.isNotEmpty(dbList)) {
                        for (String str : dbList) {
                            System.out.println("database: " + str);
                        }
                    }
                    break block23;
                }
                if (args.length == 3) {
                    List<String> tableList = hc.getTableList(args[2], null, null);
                    if (tableList.size() == 0) {
                        System.out.println("No tables found under database[" + args[1] + "] with table filter [" + args[2] + "]");
                    } else {
                        for (String str : tableList) {
                            System.out.println("Table: " + str);
                        }
                    }
                } else if (args.length == 4) {
                    List<String> columnList = hc.getColumnList(args[3], null, null, null);
                    if (columnList.size() == 0) {
                        System.out.println("No columns found for db:" + args[1] + ", table: [" + args[2] + "], with column filter [" + args[3] + "]");
                    } else {
                        for (String str : columnList) {
                            System.out.println("Column: " + str);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (hc != null) {
                    hc.close();
                }
            }
        }
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> connectionProperties) throws Exception {
        HiveClient connectionObj = null;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        boolean connectivityStatus = false;
        List<String> testResult = null;
        try {
            connectionObj = new HiveClient(serviceName, connectionProperties);
            if (connectionObj != null) {
                testResult = connectionObj.getDatabaseList("*", null);
                if (testResult != null && testResult.size() != 0) {
                    connectivityStatus = true;
                }
                if (connectivityStatus) {
                    String successMsg = "ConnectionTest Successful";
                    HiveClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
                } else {
                    String failureMsg = "Unable to retrieve any databases using given parameters.";
                    HiveClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + ERR_MSG), null, null, responseData);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (connectionObj != null) {
                connectionObj.close();
            }
        }
        return responseData;
    }
}

