/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerAbstractContextEnricher
implements RangerContextEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAbstractContextEnricher.class);
    protected RangerServiceDef.RangerContextEnricherDef enricherDef;
    protected String serviceName;
    protected String appId;
    protected RangerServiceDef serviceDef;
    private RangerPluginContext pluginContext;
    protected RangerPolicyEngineOptions options = new RangerPolicyEngineOptions();

    @Override
    public void setEnricherDef(RangerServiceDef.RangerContextEnricherDef enricherDef) {
        this.enricherDef = enricherDef;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setServiceDef(RangerServiceDef serviceDef) {
        this.serviceDef = serviceDef;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void init() {
        RangerAuthContext authContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractContextEnricher.init(" + this.enricherDef + ")");
        }
        if ((authContext = this.getAuthContext()) != null) {
            authContext.addOrReplaceRequestContextEnricher(this, null);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("authContext is null. This context-enricher is not added to authContext");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractContextEnricher.init(" + this.enricherDef + ")");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        this.enrich(request);
    }

    @Override
    public boolean preCleanup() {
        RangerAuthContext authContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractContextEnricher.preCleanup(" + this.enricherDef + ")");
        }
        if ((authContext = this.getAuthContext()) != null) {
            authContext.cleanupRequestContextEnricher(this);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("authContext is null. AuthContext need not be cleaned.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractContextEnricher.preCleanup(" + this.enricherDef + ")");
        }
        return true;
    }

    @Override
    public void cleanup() {
        this.preCleanup();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getName() {
        return this.enricherDef == null ? null : this.enricherDef.getName();
    }

    public RangerServiceDef.RangerContextEnricherDef getEnricherDef() {
        return this.enricherDef;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getOption(String name) {
        Map<String, String> options;
        String ret = null;
        Map<String, String> map = options = this.enricherDef != null ? this.enricherDef.getEnricherOptions() : null;
        if (options != null && name != null) {
            ret = options.get(name);
        }
        return ret;
    }

    public RangerAuthContext getAuthContext() {
        RangerPluginContext pluginContext = this.pluginContext;
        return pluginContext != null ? pluginContext.getAuthContext() : null;
    }

    public final void setPluginContext(RangerPluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public RangerPluginContext getPluginContext() {
        return this.pluginContext;
    }

    public final void setPolicyEngineOptions(RangerPolicyEngineOptions options) {
        this.options = options;
    }

    public RangerPluginConfig getPluginConfig() {
        RangerPluginContext pluginContext = this.pluginContext;
        return pluginContext != null ? pluginContext.getConfig() : null;
    }

    public RangerPolicyEngineOptions getPolicyEngineOptions() {
        return this.options;
    }

    public void notifyAuthContextChanged() {
        RangerPluginContext pluginContext = this.pluginContext;
        if (pluginContext != null) {
            pluginContext.notifyAuthContextChanged();
        }
    }

    public String getPropertyPrefix() {
        RangerPluginConfig pluginConfig = this.getPluginConfig();
        return pluginConfig != null ? pluginConfig.getPropertyPrefix() : "ranger.plugin." + this.serviceDef.getName();
    }

    public String getConfig(String configName, String defaultValue) {
        RangerPluginConfig config;
        RangerPluginContext pluginContext = this.pluginContext;
        String ret = defaultValue;
        RangerPluginConfig rangerPluginConfig = config = pluginContext != null ? pluginContext.getConfig() : null;
        if (config != null) {
            ret = config.get(configName, defaultValue);
        }
        return ret;
    }

    public int getIntConfig(String configName, int defaultValue) {
        RangerPluginConfig config;
        RangerPluginContext pluginContext = this.pluginContext;
        int ret = defaultValue;
        RangerPluginConfig rangerPluginConfig = config = pluginContext != null ? pluginContext.getConfig() : null;
        if (config != null) {
            ret = config.getInt(configName, defaultValue);
        }
        return ret;
    }

    public boolean getBooleanConfig(String configName, boolean defaultValue) {
        RangerPluginConfig config;
        RangerPluginContext pluginContext = this.pluginContext;
        boolean ret = defaultValue;
        RangerPluginConfig rangerPluginConfig = config = pluginContext != null ? pluginContext.getConfig() : null;
        if (config != null) {
            ret = config.getBoolean(configName, defaultValue);
        }
        return ret;
    }

    public String getOption(String name, String defaultValue) {
        String ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = val;
        }
        return ret;
    }

    public boolean getBooleanOption(String name, boolean defaultValue) {
        boolean ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = Boolean.parseBoolean(val);
        }
        return ret;
    }

    public char getCharOption(String name, char defaultValue) {
        char ret = defaultValue;
        String val = this.getOption(name);
        if (!StringUtils.isEmpty((CharSequence)val)) {
            ret = val.charAt(0);
        }
        return ret;
    }

    public long getLongOption(String name, long defaultValue) {
        long ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = Long.parseLong(val);
        }
        return ret;
    }

    public Properties readProperties(String fileName) {
        Throwable throwable;
        InputStream inStr;
        Properties ret = null;
        URL fileURL = null;
        File f = new File(fileName);
        if (f.exists() && f.isFile() && f.canRead()) {
            try {
                inStr = new FileInputStream(f);
                throwable = null;
                try {
                    fileURL = f.toURI().toURL();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inStr != null) {
                        if (throwable != null) {
                            try {
                                inStr.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            inStr.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException exception) {
                LOG.error("Error processing input file:" + fileName + " or no privilege for reading file " + fileName, (Throwable)exception);
            }
            catch (IOException malformedException) {
                LOG.error("Error processing input file:" + fileName + " cannot be converted to URL " + fileName, (Throwable)malformedException);
            }
        } else {
            fileURL = this.getClass().getResource(fileName);
            if (fileURL == null && !fileName.startsWith("/")) {
                fileURL = this.getClass().getResource("/" + fileName);
            }
            if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(fileName)) == null && !fileName.startsWith("/")) {
                fileURL = ClassLoader.getSystemClassLoader().getResource("/" + fileName);
            }
        }
        if (fileURL != null) {
            try {
                inStr = fileURL.openStream();
                throwable = null;
                try {
                    Properties prop = new Properties();
                    prop.load(inStr);
                    ret = prop;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inStr != null) {
                        if (throwable != null) {
                            try {
                                inStr.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inStr.close();
                        }
                    }
                }
            }
            catch (Exception excp) {
                LOG.error("failed to load properties from file '" + fileName + "'", (Throwable)excp);
            }
        }
        return ret;
    }
}

