/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from "react";
import { Table } from "react-bootstrap";
import { UsersyncDetailsKeyDisplayMap } from "Utils/XAEnums";
import dateFormat from "dateformat";

export function SyncSourceDetails(props) {
  return Object.keys(props.syncDetails).length == 0 ? (
    <>
      <Table bordered size="sm">
        <thead className="thead-light">
          <tr>
            <th className=" text-center">Name</th>
            <th className=" text-center">Value</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td className="text-center text-muted" colSpan="2">
              No Sync Details Found!!
            </td>
          </tr>
        </tbody>
      </Table>
    </>
  ) : (
    <>
      <Table bordered size="sm">
        <thead className="thead-light">
          <tr>
            <th className=" text-center">Name</th>
            <th className=" text-center">Value</th>
          </tr>
        </thead>
        <tbody>
          {Object.entries(props.syncDetails).map(([key, value]) => (
            <tr key={key}>
              <td>
                {UsersyncDetailsKeyDisplayMap[key]
                  ? UsersyncDetailsKeyDisplayMap[key]
                  : key}
              </td>
              <td>
                {value
                  ? key == "syncTime" || key == "lastModified"
                    ? dateFormat(value, "mm/dd/yyyy hh:MM:ss TT")
                    : value
                  : "--"}
              </td>
            </tr>
          ))}
        </tbody>
      </Table>
    </>
  );
}
export default SyncSourceDetails;
